/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.fsm;

import java.io.Serializable;

public class State
implements Serializable {
    private static final long serialVersionUID = 8481324675025780560L;
    public static final State UNKNOWN = new State(0, "UNKNOWN");
    public static final State INVALID = new State(-1, "INVALID");
    private final int code;
    private final String name;

    public State(int code, String name) {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        if (name.trim().length() == 0) {
            throw new NullPointerException("empty name");
        }
        this.code = code;
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof State)) {
            return false;
        }
        State state = (State)obj;
        if (this.code != state.getCode()) {
            return false;
        }
        return this.name.equals(state.getName());
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 37 * hashCode + this.code;
        hashCode = 37 * hashCode + this.name.hashCode();
        return hashCode;
    }

    public String toString() {
        return "State[" + this.name + "(" + this.code + ")]";
    }

    public final int getCode() {
        return this.code;
    }

    public final String getName() {
        return this.name;
    }
}

