/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.fsm;

import com.googlecode.jinahya.util.fsm.State;

public abstract class AbstractState
implements State {
    private static final long serialVersionUID = 3885354297727614037L;
    private final int code;
    private final String name;

    public static State newInstance(int code, String name) {
        return new AbstractState(code, name){
            private static final long serialVersionUID = -7766829699556888699L;
        };
    }

    public AbstractState(int code, String name) {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        if (name.trim().length() == 0) {
            throw new NullPointerException("empty name");
        }
        this.code = code;
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractState)) {
            return false;
        }
        AbstractState state = (AbstractState)obj;
        if (this.code != state.getCode()) {
            return false;
        }
        return this.name.equals(state.getName());
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 37 * hashCode + this.code;
        hashCode = 37 * hashCode + this.name.hashCode();
        return hashCode;
    }

    public String toString() {
        return "State(" + this.name + "(" + this.code + "))";
    }

    public final int getCode() {
        return this.code;
    }

    public final String getName() {
        return this.name;
    }
}

