/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.fsm;

import com.googlecode.jinahya.util.fsm.FSMException;
import com.googlecode.jinahya.util.fsm.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;

public class ClassResourceLoader
implements ResourceLoader {
    final ClassLoader classLoader;

    public ClassResourceLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("null classLoader");
        }
        this.classLoader = classLoader;
    }

    public InputStream load(String resourceName) throws IOException, FSMException {
        if (resourceName == null) {
            throw new NullPointerException("null resourceName");
        }
        if (resourceName.trim().length() == 0) {
            throw new IllegalArgumentException("empty resourceName");
        }
        InputStream resourceStream = this.classLoader.getResourceAsStream(resourceName);
        if (resourceName == null) {
            throw new FSMException("failed to load resource: " + resourceName);
        }
        return resourceStream;
    }
}

