/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.fsm;

import com.googlecode.jinahya.util.fsm.FSMException;
import com.googlecode.jinahya.util.fsm.MachineContext;
import com.googlecode.jinahya.util.fsm.State;
import com.googlecode.jinahya.util.fsm.Transition;

public class Machine {
    private volatile boolean started = false;
    private volatile boolean finished = false;
    private volatile State state = State.UNKNOWN;
    private final MachineContext context;

    public Machine(MachineContext context) {
        if (context == null) {
            throw new NullPointerException("null context");
        }
        this.context = context;
    }

    public synchronized State getState() {
        return this.state;
    }

    public synchronized void setState(State state) throws FSMException {
        if (state == null) {
            throw new NullPointerException("null state");
        }
        if (this.state.equals(state)) {
            throw new IllegalStateException("same state");
        }
        if (this.isFinished()) {
            throw new IllegalStateException("already finished");
        }
        State source = this.state;
        State target = this.state = state;
        Transition transition = new Transition(source, target);
        if (!this.isStarted()) {
            if (!this.isStarting(transition)) {
                throw new IllegalStateException("not started yet");
            }
            this.started = true;
        }
        if (this.isFinishing(transition)) {
            this.finished = true;
        }
        this.context.transited(transition);
    }

    public final synchronized boolean isStarted() {
        return this.started;
    }

    public final synchronized boolean isFinished() {
        return this.finished;
    }

    protected boolean isStarting(Transition transition) {
        return true;
    }

    protected boolean isAllowed(Transition transition) {
        return true;
    }

    protected boolean isFinishing(Transition transition) {
        return false;
    }
}

