/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.fsm;

import com.googlecode.jinahya.util.fsm.FSMException;
import com.googlecode.jinahya.util.fsm.ResourceLoader;
import com.googlecode.jinahya.util.fsm.Task;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskContext {
    private static final String TASK_INDEX_FILENAME = "task.index";
    private final Set<String> classNames;
    private volatile Map<String, Task> tasks = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getClassNames(String contextPath, ResourceLoader resourceLoader) throws FSMException {
        if (contextPath == null) {
            throw new NullPointerException("null contextPath");
        }
        if (resourceLoader == null) {
            throw new NullPointerException("null resourceLoader");
        }
        HashSet<String> packageNames = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(contextPath, ":");
        while (tokenizer.hasMoreTokens()) {
            String packageName = tokenizer.nextToken();
            if (packageName.trim().length() <= 0) continue;
            packageNames.add(packageName);
        }
        HashSet<String> classNames = new HashSet<String>();
        for (String packageName : packageNames) {
            String resourceName = packageName.replace('.', '/') + "/" + TASK_INDEX_FILENAME;
            try {
                InputStream resource = resourceLoader.load(resourceName);
                if (resource == null) {
                    throw new FSMException("resourceLoader loaded null?");
                }
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(resource, "UTF-8"));
                    try {
                        String className = null;
                        while ((className = reader.readLine()) != null) {
                            if ((className = className.trim()).length() == 0 || className.startsWith("#")) continue;
                            classNames.add(packageName + "." + className);
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                finally {
                    resource.close();
                }
            }
            catch (IOException ioe) {
                throw new FSMException(ioe);
            }
        }
        return classNames;
    }

    public TaskContext(Set<String> classNames) {
        if (classNames == null) {
            throw new NullPointerException("null classNames");
        }
        for (String className : classNames) {
            if (className != null) continue;
            throw new NullPointerException("null className");
        }
        this.classNames = new HashSet<String>(classNames);
    }

    public final synchronized Map<String, Task> getTaskMap() throws FSMException {
        if (this.tasks == null) {
            this.tasks = new HashMap<String, Task>();
            for (String className : this.classNames) {
                Class<?> loaded = this.loadClass(className);
                if (!Task.class.isAssignableFrom(loaded)) {
                    throw new FSMException("loaded task class(" + loaded + ") is not assignable to " + Task.class);
                }
                try {
                    Constructor<?> constructor = loaded.getConstructor(null);
                    try {
                        Task task = (Task)constructor.newInstance(null);
                        String taskId = task.getId();
                        if (this.tasks.containsKey(taskId)) {
                            throw new FSMException("duplicate task id: " + taskId);
                        }
                        this.tasks.put(taskId, task);
                    }
                    catch (InstantiationException ie) {
                        throw new FSMException("failed to create a new instance: " + loaded, ie);
                    }
                    catch (IllegalAccessException iae) {
                        throw new FSMException("failed to create a new instance: " + loaded, iae);
                    }
                    catch (InvocationTargetException ite) {
                        throw new FSMException("failed to create a new instance: " + loaded, ite);
                    }
                }
                catch (NoSuchMethodException nsme) {
                    throw new FSMException("no default constructor: " + loaded, nsme);
                }
            }
        }
        return new HashMap<String, Task>(this.tasks);
    }

    public final synchronized Collection<Task> getTasks() throws FSMException {
        return this.getTaskMap().values();
    }

    protected Class<?> loadClass(String className) throws FSMException {
        if (className == null) {
            throw new NullPointerException("null className");
        }
        if (className.trim().length() == 0) {
            throw new IllegalArgumentException("empty className");
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new FSMException(cnfe);
        }
    }
}

