/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.sql;

import com.googlecode.jinahya.sql.DatabaseAccessible;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatabaseAccessibleHelper {
    public static <A extends DatabaseAccessible<I>, I> A select(Connection connection, Class<A> accessibleType, I id) throws SQLException {
        try {
            DatabaseAccessible instance = (DatabaseAccessible)accessibleType.newInstance();
            instance.setId(id);
            if (DatabaseAccessibleHelper.select(connection, instance)) {
                return (A)instance;
            }
            return null;
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("failed to create a new instance of " + accessibleType, iae);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("failed to create a new instance of " + accessibleType, ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A extends DatabaseAccessible<?>> boolean select(Connection connection, A accessible) throws SQLException {
        if (connection == null) {
            throw new NullPointerException("null connection");
        }
        if (accessible == null) {
            throw new NullPointerException("null accessible");
        }
        if (accessible.getId() == null) {
            throw new IllegalArgumentException("null accessible.id");
        }
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + accessible.getTableName() + " WHERE " + accessible.getIdColumnName() + " = ?");
        try {
            ResultSet resultSet;
            block11: {
                boolean bl;
                int parameterIndex = 0;
                preparedStatement.setObject(++parameterIndex, accessible.getId(), accessible.getIdType());
                resultSet = preparedStatement.executeQuery();
                try {
                    if (resultSet.next()) break block11;
                    bl = false;
                }
                catch (Throwable throwable) {
                    resultSet.close();
                    throw throwable;
                }
                resultSet.close();
                return bl;
            }
            accessible.read(resultSet);
            boolean bl = true;
            resultSet.close();
            return bl;
        }
        finally {
            preparedStatement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A extends DatabaseAccessible<I>, I> boolean delete(Connection connection, String tableName, String idColumnName, I id, int idType) throws SQLException {
        if (connection == null) {
            throw new NullPointerException("null connection");
        }
        PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM " + tableName + " WHERE " + idColumnName + " = ?");
        try {
            int parameterIndex = 0;
            preparedStatement.setObject(++parameterIndex, id, idType);
            boolean bl = preparedStatement.executeUpdate() == 1;
            return bl;
        }
        finally {
            preparedStatement.close();
        }
    }

    public static <A extends DatabaseAccessible<I>, I> boolean delete(Connection connection, A accessible) throws SQLException {
        return DatabaseAccessibleHelper.delete(connection, accessible.getTableName(), accessible.getIdColumnName(), accessible.getId(), accessible.getIdType());
    }

    private DatabaseAccessibleHelper() {
    }
}

