/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.sql;

import com.googlecode.jinahya.sql.AbstractDatabaseAccessible;
import com.googlecode.jinahya.sql.DatabaseAccessible;
import com.googlecode.jinahya.sql.DatabaseCollectable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatabaseCollectableHelper {
    public static <C extends DatabaseCollectable<A>, A extends AbstractDatabaseAccessible<?>> C select(Connection connection, String tableName, String idColumnName, Class<C> collectableType) throws SQLException {
        try {
            DatabaseCollectable collectable = (DatabaseCollectable)collectableType.newInstance();
            DatabaseCollectableHelper.select(connection, tableName, idColumnName, collectable);
            return (C)collectable;
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("failed to create a new instance of " + collectableType, iae);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("failed to create a new instance of " + collectableType, ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <C extends DatabaseCollectable<A>, A extends DatabaseAccessible<?>> void select(Connection connection, String tableName, String idColumnName, C collectable) throws SQLException {
        if (connection == null) {
            throw new NullPointerException("null connection");
        }
        if (tableName == null) {
            throw new NullPointerException("null elementTableName");
        }
        if (idColumnName == null) {
            throw new NullPointerException("null elementIdColumnName");
        }
        if (collectable == null) {
            throw new NullPointerException("null element");
        }
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + tableName + " ORDER BY " + idColumnName + " ASC");
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            try {
                Class accessibleType = collectable.getAccessibleType();
                Collection accessibles = collectable.getAccessibles();
                accessibles.clear();
                while (resultSet.next()) {
                    try {
                        DatabaseAccessible accessible = (DatabaseAccessible)accessibleType.newInstance();
                        accessible.read(resultSet);
                        accessibles.add(accessible);
                    }
                    catch (IllegalAccessException iae) {
                        throw new RuntimeException("failed to create a new instance of " + accessibleType, iae);
                    }
                    catch (InstantiationException ie) {
                        throw new RuntimeException("failed to create a new instance of " + accessibleType, ie);
                        return;
                    }
                }
            }
            finally {
                resultSet.close();
            }
        }
        finally {
            preparedStatement.close();
        }
    }

    private DatabaseCollectableHelper() {
    }
}

