/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SequenceManager {
    private final DataSource dataSource;
    private final int minimumSize;
    private final int maximumSize;
    private final Map<String, List<Long>> map;

    public SequenceManager(DataSource dataSource, int minimumSize, int maximumSize) {
        if (dataSource == null) {
            throw new NullPointerException("null dataSource");
        }
        if (minimumSize <= 0) {
            throw new IllegalArgumentException("minimumSize(" + minimumSize + ") <= 0");
        }
        if (maximumSize <= 0) {
            throw new IllegalArgumentException("maximumSize(" + maximumSize + ") <=0");
        }
        if (minimumSize >= maximumSize) {
            throw new IllegalArgumentException("minimumSize(" + maximumSize + ") >= maximumSize(" + maximumSize + ")");
        }
        this.dataSource = dataSource;
        this.minimumSize = minimumSize;
        this.maximumSize = maximumSize;
        this.map = Collections.synchronizedMap(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNextValue(String sequenceName) throws SQLException {
        Map<String, List<Long>> map = this.map;
        synchronized (map) {
            List<Long> list;
            if (!this.map.containsKey(sequenceName)) {
                this.map.put(sequenceName, new LinkedList());
            }
            if ((list = this.map.get(sequenceName)).size() < this.minimumSize) {
                Connection connection = this.dataSource.getConnection();
                try {
                    this.fetchNextValues(connection, sequenceName, list, this.maximumSize - list.size());
                }
                finally {
                    connection.close();
                }
            }
            return list.remove(0);
        }
    }

    protected abstract void fetchNextValues(Connection var1, String var2, List<Long> var3, int var4) throws SQLException;

    protected final Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public final int getMinimumSize() {
        return this.minimumSize;
    }

    public final int getMaximumSize() {
        return this.maximumSize;
    }
}

