/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.sql;

import com.googlecode.jinahya.sql.DbAccessible;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.annotation.XmlTransient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlTransient
public abstract class AbstractDbAccessible<I>
implements DbAccessible<I> {
    private I id;
    protected final String tableName;
    protected final String idColumnName;
    private final int idType;

    protected static Byte getByte(ResultSet resultSet, String columnLabel) throws SQLException {
        Byte value = resultSet.getByte(columnLabel);
        if (resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    protected static byte getByte(ResultSet resultSet, String columnLabel, byte defaultValue) throws SQLException {
        Byte value = AbstractDbAccessible.getByte(resultSet, columnLabel);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    protected static Short getShort(ResultSet resultSet, String columnLabel) throws SQLException {
        Short value = resultSet.getShort(columnLabel);
        if (resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    protected static short getShort(ResultSet resultSet, String columnLabel, short defaultValue) throws SQLException {
        Integer value = AbstractDbAccessible.getInt(resultSet, columnLabel);
        if (value == null) {
            return defaultValue;
        }
        return value.shortValue();
    }

    protected static Integer getInt(ResultSet resultSet, String columnLabel) throws SQLException {
        Integer value = resultSet.getInt(columnLabel);
        if (resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    protected static int getInt(ResultSet resultSet, String columnLabel, int defaultValue) throws SQLException {
        Integer value = AbstractDbAccessible.getInt(resultSet, columnLabel);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    protected static Long getLong(ResultSet resultSet, String columnLabel) throws SQLException {
        Long value = resultSet.getLong(columnLabel);
        if (resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    protected static long getLong(ResultSet resultSet, String columnLabel, long defaultValue) throws SQLException {
        Long value = AbstractDbAccessible.getLong(resultSet, columnLabel);
        if (resultSet.wasNull()) {
            return defaultValue;
        }
        return value;
    }

    protected static Float getFloat(ResultSet resultSet, String columnLabel) throws SQLException {
        Float value = Float.valueOf(resultSet.getFloat(columnLabel));
        if (resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    protected static float getFloat(ResultSet resultSet, String columnLabel, float defaultValue) throws SQLException {
        Float value = AbstractDbAccessible.getFloat(resultSet, columnLabel);
        if (value == null) {
            return defaultValue;
        }
        return value.floatValue();
    }

    protected static Double getDouble(ResultSet resultSet, String columnLabel) throws SQLException {
        Double value = resultSet.getDouble(columnLabel);
        if (resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    protected static double getDouble(ResultSet resultSet, String columnLabel, float defaultValue) throws SQLException {
        Double value = AbstractDbAccessible.getDouble(resultSet, columnLabel);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    protected static Date getTimestamp(ResultSet resultSet, String columnLabel) throws SQLException {
        Timestamp value = resultSet.getTimestamp(columnLabel);
        if (value == null) {
            return null;
        }
        return new Date(value.getTime());
    }

    protected static Date getTimestamp(ResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        Timestamp value = resultSet.getTimestamp(columnLabel, cal);
        if (value == null) {
            return null;
        }
        return new Date(value.getTime());
    }

    protected static void setTimestamp(CallableStatement callableStatement, int parameterIndex, Long value) throws SQLException {
        if (value == null) {
            callableStatement.setNull(parameterIndex, 93);
        } else {
            callableStatement.setTimestamp(parameterIndex, new Timestamp(value));
        }
    }

    protected static void setTimestamp(PreparedStatement preparedStatement, int parameterIndex, Long value) throws SQLException {
        if (value == null) {
            preparedStatement.setNull(parameterIndex, 93);
        } else {
            preparedStatement.setTimestamp(parameterIndex, new Timestamp(value));
        }
    }

    protected static void setTimestamp(CallableStatement callableStatement, int parameterIndex, Date value) throws SQLException {
        if (value == null) {
            AbstractDbAccessible.setTimestamp(callableStatement, parameterIndex, (Long)null);
        } else {
            AbstractDbAccessible.setTimestamp(callableStatement, parameterIndex, (Long)value.getTime());
        }
    }

    protected static void setTimestamp(PreparedStatement preparedStatement, int parameterIndex, Date value) throws SQLException {
        if (value == null) {
            AbstractDbAccessible.setTimestamp(preparedStatement, parameterIndex, (Long)null);
        } else {
            AbstractDbAccessible.setTimestamp(preparedStatement, parameterIndex, (Long)value.getTime());
        }
    }

    public AbstractDbAccessible(String tableName, String idColumnName, int idType) {
        if (tableName == null) {
            throw new NullPointerException("null tableName");
        }
        if (tableName.trim().length() == 0) {
            throw new IllegalArgumentException("empty tableName");
        }
        if (idColumnName == null) {
            throw new NullPointerException("null idColumnName");
        }
        if (idColumnName.trim().length() == 0) {
            throw new IllegalArgumentException("empty idColumnName");
        }
        this.tableName = tableName;
        this.idColumnName = idColumnName;
        this.idType = idType;
    }

    @Override
    public I getId() {
        return this.id;
    }

    @Override
    public void setId(I id) {
        this.id = id;
    }

    @Override
    public final int getIdType() {
        return this.idType;
    }

    @Override
    public final String getTableName() {
        return this.tableName;
    }

    @Override
    public final String getIdColumnName() {
        return this.idColumnName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean select(Connection connection) throws SQLException {
        if (connection == null) {
            throw new NullPointerException("null connection");
        }
        if (this.getId() == null) {
            throw new IllegalStateException("null id");
        }
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + this.tableName + " WHERE " + this.idColumnName + " = ?");
        try {
            ResultSet resultSet;
            block10: {
                boolean bl;
                int parameterIndex = 0;
                preparedStatement.setObject(++parameterIndex, this.getId(), this.getIdType());
                resultSet = preparedStatement.executeQuery();
                try {
                    if (resultSet.next()) break block10;
                    bl = false;
                }
                catch (Throwable throwable) {
                    resultSet.close();
                    throw throwable;
                }
                resultSet.close();
                return bl;
            }
            this.read(resultSet);
            boolean bl = true;
            resultSet.close();
            return bl;
        }
        finally {
            preparedStatement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(Connection connection) throws SQLException {
        if (connection == null) {
            throw new NullPointerException("null connection");
        }
        if (this.getId() == null) {
            throw new IllegalStateException("null id");
        }
        PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM " + this.tableName + " WHERE " + this.idColumnName + " = ?");
        try {
            int parameterIndex = 0;
            preparedStatement.setObject(++parameterIndex, this.id, this.idType);
            boolean bl = preparedStatement.executeUpdate() == 1;
            return bl;
        }
        finally {
            preparedStatement.close();
        }
    }

    @Override
    public void read(ResultSet resultSet) throws SQLException {
        this.read(resultSet, "");
    }
}

