/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.sql;

import com.googlecode.jinahya.sql.SequenceManager;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableSequenceManager
extends SequenceManager {
    private static final int TYPE = 1005;
    private static final int CONCURRENCY = 1008;
    private final String table;
    private final String pkColumnName;
    private final String valueColumnName;

    public TableSequenceManager(DataSource dataSource, int minimumSize, int maximumSize, String table, String pkColumnName, String valueColumnName) {
        super(dataSource, minimumSize, maximumSize);
        this.table = table;
        this.pkColumnName = pkColumnName;
        this.valueColumnName = valueColumnName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fetchNextValues(Connection connection, String sequenceName, List<Long> sequenceValues, int fetchCount) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        boolean commit = connection.getAutoCommit();
        int isolation = connection.getTransactionIsolation();
        try {
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(4);
            try {
                if (metaData.supportsResultSetConcurrency(1005, 1008)) {
                    this.fetchConcurrently(connection, sequenceName, sequenceValues, fetchCount);
                } else {
                    this.fetchSeparately(connection, sequenceName, sequenceValues, fetchCount);
                }
                connection.commit();
            }
            catch (SQLException sqle) {
                connection.rollback();
                throw sqle;
            }
        }
        finally {
            connection.setAutoCommit(commit);
            connection.setTransactionIsolation(isolation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchConcurrently(Connection connection, String sequenceName, List<Long> sequenceValues, int fetchCount) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + this.table + " WHERE " + this.pkColumnName + " = ?" + " FOR UPDATE", 1005, 1008);
        try {
            ResultSet resultSet;
            block10: {
                int parameterIndex = 0;
                preparedStatement.setString(++parameterIndex, sequenceName);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block10;
                long sequenceValue = resultSet.getLong(this.valueColumnName);
                for (int i = 0; i < fetchCount; ++i) {
                    sequenceValues.add(++sequenceValue);
                }
                resultSet.updateLong(this.valueColumnName, sequenceValue);
                resultSet.updateRow();
                resultSet.close();
                return;
            }
            try {
                long sequenceValue = -1L;
                for (int i = 0; i < fetchCount; ++i) {
                    sequenceValues.add(++sequenceValue);
                }
                resultSet.moveToInsertRow();
                resultSet.updateString(this.pkColumnName, sequenceName);
                resultSet.updateLong(this.valueColumnName, sequenceValue);
                resultSet.insertRow();
            }
            catch (Throwable throwable) {
                resultSet.close();
                throw throwable;
            }
            resultSet.close();
            return;
        }
        finally {
            preparedStatement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchSeparately(Connection connection, String sequenceName, List<Long> sequenceValues, int fetchCount) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + this.table + " WHERE " + this.pkColumnName + " = ?" + " FOR UPDATE");
        try {
            ResultSet resultSet;
            block9: {
                int parameterIndex = 0;
                preparedStatement.setString(++parameterIndex, sequenceName);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block9;
                this.insert(connection, sequenceName);
                this.fetchSeparately(connection, sequenceName, sequenceValues, fetchCount);
                resultSet.close();
                return;
            }
            try {
                long sequenceValue = resultSet.getLong(this.valueColumnName);
                for (int i = 0; i < fetchCount; ++i) {
                    sequenceValues.add(++sequenceValue);
                }
                this.update(connection, sequenceName, sequenceValue);
            }
            catch (Throwable throwable) {
                resultSet.close();
                throw throwable;
            }
            resultSet.close();
            return;
        }
        finally {
            preparedStatement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(Connection connection, String sequenceName) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INO " + this.table + " (" + this.pkColumnName + ", " + this.valueColumnName + ")" + " VALUES (?, ?)");
        try {
            int parameterIndex = 0;
            preparedStatement.setString(++parameterIndex, sequenceName);
            preparedStatement.setLong(++parameterIndex, -1L);
            int result = preparedStatement.executeUpdate();
            if (result != 1) {
                throw new SQLException("insert result(" + result + ") != 1");
            }
        }
        finally {
            preparedStatement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Connection connection, String sequenceName, long sequenceValue) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("UPDATE " + this.table + " SET " + this.valueColumnName + " = ?" + " WHERE " + this.pkColumnName + " = ?");
        try {
            int parameterIndex = 0;
            preparedStatement.setLong(++parameterIndex, sequenceValue);
            preparedStatement.setString(++parameterIndex, sequenceName);
            int result = preparedStatement.executeUpdate();
            if (result != 1) {
                throw new SQLException("update result(" + result + ") != 1");
            }
        }
        finally {
            preparedStatement.close();
        }
    }
}

