/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.sql.oracle;

import com.googlecode.jinahya.sql.SequenceManager;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleSequenceManager
extends SequenceManager {
    private static final int DEFAULT_MINIMUM_COUNT = 10;
    private static final int DEFAULT_MAXIMUM_COUNT = 100;

    public OracleSequenceManager(DataSource dataSource) {
        this(dataSource, 10, 100);
    }

    public OracleSequenceManager(DataSource dataSource, int minimumCount, int maximumCount) {
        super(dataSource, minimumCount, maximumCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fetchNextValues(Connection connection, String sequenceName, List<Long> sequenceValues, int fetchCount) throws SQLException {
        if (sequenceValues.size() >= this.getMaximumSize()) {
            return;
        }
        CallableStatement preparedStatement = connection.prepareCall("SELECT LEVEL, " + sequenceName + ".NEXTVAL FROM DUAL" + " CONNECT BY LEVEL <= ?");
        try {
            int parameterIndex = 0;
            preparedStatement.setInt(++parameterIndex, fetchCount);
            ResultSet resultSet = preparedStatement.executeQuery();
            try {
                while (resultSet.next()) {
                    sequenceValues.add(resultSet.getLong(sequenceName + ".NEXTVAL"));
                }
            }
            finally {
                resultSet.close();
            }
        }
        finally {
            preparedStatement.close();
        }
    }
}

