/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.servlet.http;

import com.googlecode.jinahya.servlet.AbstractFilter;
import com.googlecode.jinahya.servlet.http.BufferedHttpServletResponseWrapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public abstract class XSLTFilter
extends AbstractFilter {
    protected static final String PREFERRED_CHARACTER_ENCODING = "UTF-8";
    private TransformerFactory transformerFactory;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Transformer transformer;
        StreamSource source;
        URL resource;
        if (request instanceof HttpServletRequest) {
            throw new IllegalArgumentException(request + " is not an instance of" + HttpServletRequest.class);
        }
        if (request instanceof HttpServletResponse) {
            throw new IllegalArgumentException(response + " is not an instance of" + HttpServletResponse.class);
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        BufferedHttpServletResponseWrapper responseWrapper = new BufferedHttpServletResponseWrapper(httpResponse);
        chain.doFilter(request, (ServletResponse)responseWrapper);
        byte[] outputBytes = responseWrapper.getBytes();
        int status = responseWrapper.getStatus();
        if (status != 200) {
            ((HttpServletResponse)response).setStatus(status);
            response.setContentType(responseWrapper.getContentType());
            response.setCharacterEncoding(responseWrapper.getCharacterEncoding());
            response.getOutputStream().write(outputBytes);
            response.flushBuffer();
            return;
        }
        try {
            resource = this.getStylesheetResource();
            if (resource == null) {
                ((HttpServletResponse)response).sendError(500, "failed to get stylesheet resource: null returned");
                return;
            }
        }
        catch (IOException e) {
            ((HttpServletResponse)response).sendError(500, "failed to get stylesheet resource: " + e.getMessage());
            return;
        }
        try {
            source = new StreamSource(resource.openStream());
        }
        catch (IOException ioe) {
            ((HttpServletResponse)response).sendError(500, "failed to open stream from stylesheet resource(" + resource + "): " + ioe.getMessage());
            return;
        }
        try {
            transformer = this.getTransformerFactory().newTransformer(source);
        }
        catch (TransformerConfigurationException tce) {
            ((HttpServletResponse)response).sendError(500, "failed to create transformer: " + tce.getMessage());
            return;
        }
        Properties properties = new Properties();
        this.getTransformerOutputProperties(properties);
        transformer.setOutputProperties(properties);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        this.getTransformerParameters(parameters);
        for (Map.Entry parameter : parameters.entrySet()) {
            transformer.setParameter((String)parameter.getKey(), parameter.getValue());
        }
        httpResponse.setStatus(200);
        httpResponse.setContentType(this.getOutputContentType());
        httpResponse.setCharacterEncoding(this.getOutputCharacterEncoding());
        try {
            transformer.transform(new StreamSource(new InputStreamReader((InputStream)new ByteArrayInputStream(outputBytes), responseWrapper.getCharacterEncoding())), new StreamResult(response.getWriter()));
            response.flushBuffer();
            return;
        }
        catch (TransformerException te) {
            ((HttpServletResponse)response).sendError(500, "failed to transform: " + te.getMessage());
            return;
        }
    }

    protected void getTransformerOutputProperties(Properties properties) {
        properties.put("encoding", this.getOutputCharacterEncoding());
    }

    protected abstract void getTransformerParameters(Map<String, Object> var1);

    protected abstract URL getStylesheetResource() throws IOException;

    protected abstract String getOutputContentType();

    protected abstract String getOutputCharacterEncoding();

    protected TransformerFactory getTransformerFactory() {
        if (this.transformerFactory == null) {
            this.transformerFactory = TransformerFactory.newInstance();
        }
        return this.transformerFactory;
    }
}

