/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.validation;

import com.googlecode.jinahya.validation.constraints.NormalizedStringSize;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;

public class NormalizedStringSizeValidator
implements ConstraintValidator<NormalizedStringSize, String> {
    private int min;
    private int max;

    public void initialize(NormalizedStringSize constraintAnnotation) {
        this.min = constraintAnnotation.min();
        this.max = constraintAnnotation.max();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        String collapsed = new CollapsedStringAdapter().unmarshal(value);
        return collapsed.length() > this.min && collapsed.length() < this.max;
    }
}

