/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.persistence;

import javax.persistence.EntityManager;

public class EntityFacadeSupport {
    public static <E, I> E find(EntityManager entityManager, Class<E> entityClass, I primaryKey) {
        if (entityManager == null) {
            throw new IllegalArgumentException("null entityManager");
        }
        if (entityClass == null) {
            throw new IllegalArgumentException("null entityClass");
        }
        if (primaryKey == null) {
            throw new IllegalArgumentException("null primaryKey");
        }
        return (E)entityManager.find(entityClass, primaryKey);
    }

    public static <E> void persist(EntityManager entityManager, Class<E> entityClass, E entityInstance) {
        if (entityManager == null) {
            throw new IllegalArgumentException("null entityManager");
        }
        if (entityClass == null) {
            throw new IllegalArgumentException("null entityClass");
        }
        if (entityInstance == null) {
            throw new IllegalArgumentException("null entity instance");
        }
        entityManager.persist(entityInstance);
    }

    public static <E> E merge(EntityManager entityManager, Class<E> entityClass, E entityInstance) {
        if (entityManager == null) {
            throw new IllegalArgumentException("null entityManager");
        }
        if (entityClass == null) {
            throw new IllegalArgumentException("null entityClass");
        }
        if (entityInstance == null) {
            throw new IllegalArgumentException("null entity instance");
        }
        Object merged = entityManager.merge(entityInstance);
        return (E)merged;
    }

    public static <E, I> E remove(EntityManager entityManager, Class<E> entityClass, I primaryKey) {
        if (entityManager == null) {
            throw new IllegalArgumentException("null entityManager");
        }
        if (entityClass == null) {
            throw new IllegalArgumentException("null entityClass");
        }
        if (primaryKey == null) {
            throw new IllegalArgumentException("null primaryKey");
        }
        Object entityInstance = entityManager.getReference(entityClass, primaryKey);
        if (entityInstance != null) {
            entityManager.remove(entityInstance);
        }
        return (E)entityInstance;
    }

    protected EntityFacadeSupport() {
    }
}

