/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.persistence;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlTransient;

@MappedSuperclass
@XmlTransient
public abstract class MappedMorton
implements Serializable {
    private static final long serialVersionUID = 4243525203653288446L;
    private static final Logger LOGGER = Logger.getLogger(MappedMorton.class.getName());
    protected static final int DENSITY_MIN = 1;
    protected static final int DENSITY_MAX = 26;
    protected static final int MAPPED_DENSITY = 16;
    protected static final int SODIUM_SIZE_MIN = 8;
    protected static final int SODIUM_SIZE_MAX = 64;
    protected static final int MAPPED_SODIUM_LENGTH = 32;
    @Basic(optional=false)
    @Column(name="DENSITY", nullable=false, updatable=false)
    @Min(value=1L)
    @Max(value=26L)
    @XmlTransient
    private int density;
    @Basic(optional=false)
    @Column(name="SODIUM", nullable=false, updatable=false)
    @NotNull
    @Size(min=8, max=64)
    @XmlTransient
    private byte[] sodium;

    protected static byte[] pbkdf2(char[] password, byte[] salt, int iterationCount, int keyLength) {
        long start = System.currentTimeMillis();
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec keySpec = new PBEKeySpec(password, salt, iterationCount, keyLength);
            try {
                SecretKey secretKey = secretKeyFactory.generateSecret(keySpec);
                long finish = System.currentTimeMillis();
                LOGGER.log(Level.INFO, "elapsed: {0} ms", finish - start);
                return secretKey.getEncoded();
            }
            catch (InvalidKeySpecException ikse) {
                throw new RuntimeException(ikse);
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
    }

    protected static char[] cassword(byte[] bassword) {
        if (bassword == null) {
            throw new NullPointerException("null bassword");
        }
        if (bassword.length == 0) {
            throw new IllegalArgumentException("empty bassword");
        }
        char[] cassword = new char[bassword.length];
        for (int i = 0; i < cassword.length; ++i) {
            cassword[i] = (char)(bassword[i] & 0xFF);
        }
        return cassword;
    }

    protected static int iterationCount(int density, byte[] bland) {
        int degree = 1 << density;
        return new BigInteger(bland).intValue() & degree - 1 | degree;
    }

    protected static byte[] sodium(int length) {
        byte[] sodium = new byte[length];
        try {
            SecureRandom.getInstance("SHA1PRNG").nextBytes(sodium);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
        return sodium;
    }

    protected MappedMorton(int density, byte[] sodium) {
        this.density = density;
        this.sodium = Arrays.copyOf(sodium, sodium.length);
    }

    public MappedMorton() {
        this(16, MappedMorton.sodium(32));
    }

    public byte[] salty(byte[] bland) {
        if (bland == null) {
            throw new NullPointerException("null bland");
        }
        if (bland.length == 0) {
            throw new IllegalArgumentException("empty bland");
        }
        return MappedMorton.pbkdf2(MappedMorton.cassword(bland), this.sodium, MappedMorton.iterationCount(this.density, bland), this.sodium.length * 8);
    }

    static {
        LOGGER.setLevel(Level.INFO);
    }
}

