/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.servlet.http;

import com.googlecode.jinahya.servlet.http.HttpFilter;
import com.googlecode.jinahya.servlet.http.RequestHeaderWrapper;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSuffixToMediaTypeDispatcher
extends HttpFilter {
    public static final String FILE_SUFFIX_EXPRESSION = "file\\.suffix\\.([^\\.]+)";
    protected static final Pattern FILE_SUFFIX_PATTERN = Pattern.compile("file\\.suffix\\.([^\\.]+)");
    public static final String MEDIA_TYPE_EXPRESSION = "media/type/(.+)";
    protected static final Pattern MEDIA_TYPE_PATTERN = Pattern.compile("media/type/(.+)");
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile("([^\\.]+)\\.([^\\.]+)");
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSuffixToMediaTypeDispatcher.class);
    private transient String contextPath;
    private transient int contextPathLength;
    private Map<String, String> map = null;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.contextPath = this.getServletContext().getContextPath();
        this.contextPathLength = this.contextPath.length();
        Enumeration initParametrNames = filterConfig.getInitParameterNames();
        while (initParametrNames.hasMoreElements()) {
            String parameterValue;
            Matcher mediaTypeMatcher;
            String parameterName = (String)initParametrNames.nextElement();
            Matcher fileSuffixMatcher = FILE_SUFFIX_PATTERN.matcher(parameterName);
            if (!fileSuffixMatcher.matches() || !(mediaTypeMatcher = MEDIA_TYPE_PATTERN.matcher(parameterValue = filterConfig.getInitParameter(parameterName))).matches()) continue;
            String fileSuffix = fileSuffixMatcher.group(1);
            String mediaType = mediaTypeMatcher.group(1);
            if (this.map == null) {
                this.map = new HashMap<String, String>();
            }
            LOGGER.debug("{} -> {}", (Object)fileSuffix, (Object)mediaType);
            this.map.put(fileSuffix, mediaType);
        }
    }

    @Override
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.map == null) {
            LOGGER.debug("null map");
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String requestUri = request.getRequestURI();
        if (requestUri == null) {
            LOGGER.debug("null requestUri");
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String resourcePath = requestUri.substring(this.contextPathLength);
        LOGGER.debug("resourcePath: {}", (Object)resourcePath);
        int lastSlashIndex = resourcePath.lastIndexOf(47);
        if (lastSlashIndex == -1) {
            LOGGER.debug("no last slash");
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String fileName = resourcePath.substring(lastSlashIndex + 1);
        Matcher fileNameMatcher = FILE_NAME_PATTERN.matcher(fileName);
        if (!fileNameMatcher.matches()) {
            LOGGER.debug("fileName doesn't match");
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String fileSuffix = fileNameMatcher.group(2);
        LOGGER.debug("fileSuffix: {}", (Object)fileSuffix);
        String mediaType = this.map.get(fileSuffix);
        if (mediaType == null) {
            LOGGER.debug("no mapped media type");
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String path = resourcePath.substring(0, resourcePath.length() - fileSuffix.length() - 1);
        LOGGER.debug("path: {}", (Object)path);
        HttpServletRequest wrapper = RequestHeaderWrapper.newPrecedingInstance(request, "Accept", mediaType);
        RequestDispatcher dispatcher = request.getRequestDispatcher(path);
        dispatcher.forward((ServletRequest)wrapper, (ServletResponse)response);
        LOGGER.debug("fowarded");
    }
}

