/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.servlet.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHeaderWrapper
extends HttpServletRequestWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestHeaderWrapper.class);
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public static HttpServletRequest newPrecedingInstance(HttpServletRequest request, Map<String, List<String>> headers) {
        if (headers == null) {
            throw new NullPointerException("headers");
        }
        RequestHeaderWrapper instance = new RequestHeaderWrapper(request, headers, null);
        return instance;
    }

    public static HttpServletRequest newPrecedingInstance(HttpServletRequest request, String name, List<String> values) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (values == null) {
            throw new NullPointerException("values");
        }
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>(1);
        headers.put(name, values);
        return RequestHeaderWrapper.newPrecedingInstance(request, headers);
    }

    public static HttpServletRequest newPrecedingInstance(HttpServletRequest request, String name, String value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return RequestHeaderWrapper.newPrecedingInstance(request, name, Arrays.asList(value));
    }

    public static HttpServletRequest newSuccedingInstance(HttpServletRequest request, Map<String, List<String>> headers) {
        if (headers == null) {
            throw new NullPointerException("headers");
        }
        RequestHeaderWrapper instance = new RequestHeaderWrapper(request, headers, null);
        return instance;
    }

    public static HttpServletRequest newSucceedingInstance(HttpServletRequest request, String name, List<String> values) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (values == null) {
            throw new NullPointerException("values");
        }
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>(1);
        headers.put(name, values);
        return RequestHeaderWrapper.newPrecedingInstance(request, headers);
    }

    public static HttpServletRequest newSucceedingInstance(HttpServletRequest request, String name, String value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return RequestHeaderWrapper.newPrecedingInstance(request, name, Arrays.asList(value));
    }

    public RequestHeaderWrapper(HttpServletRequest request, Map<String, List<String>> precedingHeaders, Map<String, List<String>> succeedingHeaders) {
        super(request);
        List<String> values;
        if (precedingHeaders != null) {
            for (String name : precedingHeaders.keySet()) {
                values = this.headers.get(name);
                if (values == null) {
                    values = new ArrayList<String>();
                    this.headers.put(name, values);
                }
                values.addAll((Collection<String>)precedingHeaders.get(name));
            }
        }
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name;
            name = (String)names.nextElement();
            List<String> value = this.headers.get(name);
            if (value == null) {
                value = new ArrayList<String>();
                this.headers.put(name, value);
            }
            value.addAll(Collections.list(request.getHeaders(name)));
        }
        if (succeedingHeaders != null) {
            for (String name : succeedingHeaders.keySet()) {
                values = this.headers.get(name);
                if (values == null) {
                    values = new ArrayList<String>();
                    this.headers.put(name, values);
                }
                values.addAll((Collection<String>)succeedingHeaders.get(name));
            }
        }
    }

    public String getHeader(String name) {
        LOGGER.debug("getHeader({})", (Object)name);
        List<String> values = this.headers.get(name);
        if (values != null && !values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    public Enumeration<String> getHeaders(String name) {
        LOGGER.debug("getHeaders({})", (Object)name);
        List<String> values = this.headers.get(name);
        if (values == null) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(values);
    }

    public Enumeration<String> getHeaderNames() {
        LOGGER.debug("getHeaderNames()");
        return Collections.enumeration(this.headers.keySet());
    }
}

