/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public class Ciphers {
    public static final Map<String, List<Integer>> SUPPORTED_TRANSFORMATIONS;

    public static void doFinal(Cipher cipher, InputStream input, OutputStream output, byte[] inbuf) throws IOException, IllegalBlockSizeException, BadPaddingException {
        int outlen;
        int inlen;
        if (cipher == null) {
            throw new IllegalArgumentException("cipher");
        }
        if (input == null) {
            throw new IllegalArgumentException("input");
        }
        if (output == null) {
            throw new IllegalArgumentException("output");
        }
        if (inbuf == null) {
            throw new IllegalArgumentException("inbuf");
        }
        if (inbuf.length == 0) {
            throw new IllegalArgumentException("inbuf.length == 0");
        }
        byte[] outbuf = new byte[cipher.getOutputSize(inbuf.length)];
        while ((inlen = input.read(inbuf)) != -1) {
            while (true) {
                try {
                    outlen = cipher.update(inbuf, 0, inlen, outbuf, 0);
                }
                catch (ShortBufferException sbe) {
                    outbuf = new byte[outbuf.length * 2];
                    continue;
                }
                break;
            }
            output.write(outbuf, 0, outlen);
        }
        while (true) {
            try {
                outlen = cipher.doFinal(outbuf, 0);
            }
            catch (ShortBufferException sbe) {
                outbuf = new byte[outbuf.length * 2];
                continue;
            }
            break;
        }
        output.write(outbuf, 0, outlen);
    }

    public static void doFinal(Cipher cipher, ReadableByteChannel input, WritableByteChannel output, ByteBuffer inbuf) throws IOException, IllegalBlockSizeException, BadPaddingException {
        if (cipher == null) {
            throw new IllegalArgumentException("cipher");
        }
        if (input == null) {
            throw new IllegalArgumentException("input");
        }
        if (output == null) {
            throw new IllegalArgumentException("output");
        }
        if (inbuf == null) {
            throw new NullPointerException("inbuf");
        }
        if (inbuf.capacity() == 0) {
            throw new IllegalArgumentException("inbuf.capacity(" + inbuf.capacity() + ") == 0");
        }
        ByteBuffer outbuf = ByteBuffer.allocate(cipher.getOutputSize(inbuf.capacity()));
        block4: while (true) {
            inbuf.clear();
            if (input.read(inbuf) == -1) break;
            inbuf.flip();
            outbuf.clear();
            while (true) {
                try {
                    cipher.update(inbuf, outbuf);
                    outbuf.flip();
                    while (true) {
                        if (!outbuf.hasRemaining()) continue block4;
                        output.write(outbuf);
                    }
                }
                catch (ShortBufferException sbe) {
                    outbuf = ByteBuffer.allocate(outbuf.capacity() * 2);
                    continue;
                }
                break;
            }
            break;
        }
        inbuf.limit(0);
        outbuf.clear();
        while (true) {
            try {
                cipher.doFinal(inbuf, outbuf);
                outbuf.flip();
                while (outbuf.hasRemaining()) {
                    output.write(outbuf);
                }
            }
            catch (ShortBufferException sbe) {
                outbuf = ByteBuffer.allocate(outbuf.capacity() * 2);
                continue;
            }
            break;
        }
    }

    protected Ciphers() {
    }

    static {
        HashMap<String, List<Integer>> m = new HashMap<String, List<Integer>>();
        m.put("AES/CBC/NoPadding", Arrays.asList(128));
        m.put("AES/CBC/PKCS5Padding", Arrays.asList(128));
        m.put("AES/ECB/NoPadding", Arrays.asList(128));
        m.put("AES/ECB/PKCS5Padding", Arrays.asList(128));
        m.put("DES/CBC/NoPadding", Arrays.asList(56));
        m.put("DES/CBC/PKCS5Padding", Arrays.asList(56));
        m.put("DES/ECB/NoPadding", Arrays.asList(56));
        m.put("DES/ECB/PKCS5Padding", Arrays.asList(56));
        m.put("DESede/CBC/NoPadding", Arrays.asList(168));
        m.put("DESede/CBC/PKCS5Padding", Arrays.asList(168));
        m.put("DESede/ECB/NoPadding", Arrays.asList(168));
        m.put("DESede/ECB/PKCS5Padding", Arrays.asList(168));
        m.put("RSA/ECB/PKCS1Padding", Arrays.asList(1024, 2048));
        m.put("RSA/ECB/OAEPWithSHA-1AndMGF1Padding", Arrays.asList(1024, 2048));
        m.put("RSA/ECB/OAEPWithSHA-256AndMGF1Padding", Arrays.asList(1024, 2048));
        SUPPORTED_TRANSFORMATIONS = Collections.unmodifiableMap(m);
    }
}

