/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.lang;

import com.googlecode.jinahya.lang.FieldEnum;
import java.lang.reflect.Array;

public class FieldEnumHelper {
    public static <E extends Enum<E>, F> F[] fieldValues(Class<E> enumType, Class<F> fieldType) {
        if (enumType == null) {
            throw new NullPointerException("enumtype");
        }
        if (!enumType.isEnum()) {
            throw new IllegalArgumentException("enumType(" + enumType + ") is not Enum");
        }
        if (fieldType == null) {
            throw new NullPointerException("fieldType");
        }
        Enum[] enumConstants = (Enum[])enumType.getEnumConstants();
        Object[] fieldValues = (Object[])Array.newInstance(fieldType, enumConstants.length);
        for (int i = 0; i < fieldValues.length; ++i) {
            fieldValues[i] = ((FieldEnum)((Object)enumConstants[i])).getFieldValue();
        }
        return fieldValues;
    }

    public static <E extends Enum<E>, F> E fromFieldValue(Class<E> enumType, F fieldValue) {
        if (enumType == null) {
            throw new NullPointerException("enumtype");
        }
        if (!enumType.isEnum()) {
            throw new IllegalArgumentException("enumType(" + enumType + ") is not Enum");
        }
        if (fieldValue == null) {
            // empty if block
        }
        for (Enum enumConstant : (Enum[])enumType.getEnumConstants()) {
            if (fieldValue != ((FieldEnum)((Object)enumConstant)).getFieldValue() && (fieldValue == null || !fieldValue.equals(((FieldEnum)((Object)enumConstant)).getFieldValue()))) continue;
            return (E)enumConstant;
        }
        throw new IllegalArgumentException("unknown fieldValue: " + fieldValue);
    }

    protected FieldEnumHelper() {
    }
}

