/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.security;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;

public class MessageDigests {
    public static final List<String> SUPPORTED_ALGORITHMS = Arrays.asList("MD5", "SHA-1", "SHA-256");

    public static byte[] digest(MessageDigest digest, InputStream input, byte[] buffer) throws IOException {
        int read;
        if (digest == null) {
            throw new NullPointerException("digest");
        }
        if (input == null) {
            throw new NullPointerException("input");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (buffer.length == 0) {
            throw new IllegalArgumentException("buffer.length == 0");
        }
        while ((read = input.read(buffer)) != -1) {
            digest.update(buffer, 0, read);
        }
        return digest.digest();
    }

    public static byte[] digest(MessageDigest digest, ReadableByteChannel input, ByteBuffer buffer) throws IOException {
        if (digest == null) {
            throw new NullPointerException("digest");
        }
        if (input == null) {
            throw new NullPointerException("input");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (buffer.capacity() == 0) {
            throw new IllegalArgumentException("buffer.capacity == 0");
        }
        while (true) {
            buffer.clear();
            if (input.read(buffer) == -1) break;
            buffer.flip();
            digest.update(buffer);
        }
        return digest.digest();
    }

    protected MessageDigests() {
    }
}

