/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.sql.metadata;

import com.googlecode.jinahya.sql.metadata.Catalog;
import com.googlecode.jinahya.sql.metadata.ClientInfoPropertiesMapAdapter;
import com.googlecode.jinahya.sql.metadata.ClientInfoProperty;
import com.googlecode.jinahya.sql.metadata.Retrievable;
import com.googlecode.jinahya.sql.metadata.Retrievables;
import com.googlecode.jinahya.sql.metadata.TableType;
import com.googlecode.jinahya.sql.metadata.TypeInfo;
import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class Metadata
implements Retrievable {
    @XmlAttribute
    private boolean allProceduresAreCallable;
    @XmlAttribute
    private boolean allTablesAreSelectable;
    @XmlAttribute
    private boolean autoCommitFailureClosesAllResultSets;
    @XmlAttribute
    private boolean dataDefinitionCausesTransactionCommit;
    @XmlElement
    private boolean dataDefinitionIgnoredInTransactions;
    private final Map<Integer, Boolean> deletesAreDetected = new HashMap<Integer, Boolean>();
    @XmlElement
    private boolean doesMaxRowSizeIncludeBlobs;
    @XmlElement
    private boolean generatedKeyAlwaysReturned;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=Catalog.CatalogsMapAdapter.class)
    private Map<String, Catalog> catalogs;
    private String catalogSeparator;
    private String catalogTerm;
    @XmlElement
    @XmlJavaTypeAdapter(value=ClientInfoPropertiesMapAdapter.class)
    private Map<String, ClientInfoProperty> clientInfoProperties;
    private int databaseMajorVersion;
    private int databaseMinorVersion;
    private String databaseProductName;
    private String databaseProductVersion;
    private int defaultTransactionIsolation;
    private int driverMajorVersion;
    private int driverMinorVersion;
    private String driverName;
    private String driverVersion;
    private String extraNameCharacters;
    private String identifierQuoteString;
    private int jdbcMajorVersion;
    private int jdbcMinorVersion;
    private int maxBinaryLiteralLength;
    private int maxCatalogNameLength;
    private int maxCharLeteralLength;
    private int maxColumnNameLength;
    private int maxColumnsInGroupBy;
    private int maxColumnsInIndex;
    private int maxColumnsInOrderBy;
    private int maxColumnsInSelect;
    private int maxColumnsInTable;
    private int maxConnections;
    private int maxCursorNameLength;
    private int maxIndexLength;
    private int maxProcedureNameLength;
    private int maxRowSize;
    private int maxSchemaNameLength;
    private int maxStatementLength;
    private int maxStatements;
    private int maxTableNameLength;
    private int maxTablesInSelect;
    private int maxUserNameLength;
    private List<String> numericFunctions;
    private String procedureTerm;
    private int resultSetHoldability;
    private String schemaTerm;
    private String searchStringEscape;
    private List<String> sqlKeywords;
    private int sqlStateType;
    private List<String> stringFunctions;
    private List<String> systemFunctions;
    private Collection<TableType> tableTypes;
    private List<String> timeDataFunctions;
    private Map<String, TypeInfo> typeInfo;
    private String url;
    private String userName;
    private Map<Integer, Boolean> insertsAreDetected;
    private boolean catalogAtStart;
    private boolean readOnly;
    private boolean locatorsUpdateCopy;
    private boolean nullPlusNonNullIsNull;
    private boolean nullsAreSortedAtEnd;
    private boolean nullsAreSortedAtStart;
    private boolean nullsAreSortedHigh;
    private boolean nullaAreSortedLow;
    private Map<Integer, Boolean> othersDeletesAreVisible;
    private Map<Integer, Boolean> othersInsertsAreVisible;
    private Map<Integer, Boolean> othersUpdatesAreVisible;
    private Map<Integer, Boolean> ownDeletesAreVisible;
    private Map<Integer, Boolean> ownInsertsAreVisible;
    private Map<Integer, Boolean> ownUpddatesAreVisible;
    private boolean storesLowerCaseIdentifiers;
    private boolean storesLowerCaseQuotedIdentifiers;
    private boolean storesMixedCaseIdentifiers;
    private boolean storesMixedCaseQuotedIdentifiers;
    private boolean storesUpperCaseIdentifiers;
    private boolean storesUpperCaseQuotedIdentifiers;
    private boolean supportsAlterTableWithAddColumn;
    private boolean supportsAlterTableWithDropColumn;
    private boolean supportsANSI92EntryLevelSQL;
    private boolean supportsANSI92FullSQL;
    private boolean supportsANSI92IntermediateSQL;
    private boolean supportsBatchUpdates;
    private boolean supportsCatalogsInDataManipulation;
    private boolean supportsCatalogsInIndexDefinitions;
    private boolean supportsCatalogsInPrivilegeDefinitions;
    private boolean supportsCatalogsInProcedureCalls;
    private boolean supportsCatalogsInTableDefinitions;
    private boolean supportsColumnAliasing;
    private boolean supportsConvert;
    private Map<Integer, Integer> supportedConverts;
    private boolean supportsCoreSQLGrammar;
    private boolean supportsCorrelatedSubqueries;
    private boolean supportsDataDefinitionAndDataManipulationTransactions;
    private boolean supportsDataManipulationTransactionsOnly;
    private boolean supportsDifferentTableCorrelationNames;
    private boolean supportsExpressionsInOrderBy;
    private boolean supportsExtendedSQLGrammar;
    private boolean supportsFullOuterJoins;
    private boolean supportsGetGeneratedKeys;
    private boolean supportsGroupBy;
    private boolean supportsGroupByBeyondSelect;
    private boolean supportsGroupByUnrelated;
    private boolean supportsIntegrityEnhancementFacility;
    private boolean supportsLikeEscapeClause;
    private boolean supportsLimitedOuterJoins;
    private boolean supportsMinimumSQLGrammar;
    private boolean supportsMixedCaseIdentifiers;
    private boolean supportsMixedCaseQuotedIdentifiers;
    private boolean supportsMultipleOpenResults;
    private boolean supportsMultipleResultSets;
    private boolean supportsMultipleTransactions;
    private boolean supportsNamedParameters;
    private boolean supportsNonNullableColumns;
    private boolean supportsOpenCursorsAcrossCommit;
    private boolean supportsOpenCursorsAcrossRollback;
    private boolean supportsOpenStatementsAcrossCommit;
    private boolean supportsOpenStatementsAcrossRollback;
    private boolean supportsOrderByUnrelated;
    private boolean supportsOuterJoins;
    private boolean supportsPositionedDelete;
    private boolean supportsPositionedUpdate;
    private Map<Integer, Integer> supportsResultSetConcurrency;
    private Map<Integer, Boolean> supportsResultSetHoldability;
    private Map<Integer, Boolean> supportsResultSetType;
    private boolean supportsSavepoints;
    private boolean supportsSchemasInDataManipulation;
    private boolean supportsSchemasInIndexDefinitions;
    private boolean supportsSchemasInPrivilegeDefinitions;
    private boolean supportsSchemasInProcedureCalls;
    private boolean supportsSchemasInTableDefinitions;
    private boolean supportsSelectForUpdate;
    private boolean supportsStatementPooling;
    private boolean supportsStoredFunctionsUsingCallSyntax;
    private boolean supportsStoredProcedures;
    private boolean supportsSubqueriesInComparisons;
    private boolean supportsSubqueriesInExists;
    private boolean supportsSubqueriesInIns;
    private boolean supportsSubqueriesInQuantifieds;
    private boolean supportsTableCorrelationNames;
    private Map<Integer, Boolean> supportsTransactionIsolationLevel;
    private boolean supportsTransactions;
    private boolean supportsUnion;
    private boolean supportsUnionAll;
    private Map<Integer, Boolean> updatesAreDetected;
    private boolean usesLocalFilePerTable;
    private boolean usesLocalFiles;

    public static Metadata newInstance(DatabaseMetaData databaseMetaData) {
        Metadata instance = new Metadata();
        return instance;
    }

    @Override
    public void retrieve(DatabaseMetaData databaseMetaData) throws SQLException {
        List<Retrievable> list;
        Method method;
        this.allProceduresAreCallable = databaseMetaData.allProceduresAreCallable();
        this.allTablesAreSelectable = databaseMetaData.allTablesAreSelectable();
        this.autoCommitFailureClosesAllResultSets = databaseMetaData.autoCommitFailureClosesAllResultSets();
        this.dataDefinitionCausesTransactionCommit = databaseMetaData.dataDefinitionCausesTransactionCommit();
        this.dataDefinitionIgnoredInTransactions = databaseMetaData.dataDefinitionIgnoredInTransactions();
        this.deletesAreDetected.put(1003, databaseMetaData.deletesAreDetected(1003));
        this.deletesAreDetected.put(1004, databaseMetaData.deletesAreDetected(1004));
        this.deletesAreDetected.put(1005, databaseMetaData.deletesAreDetected(1005));
        this.doesMaxRowSizeIncludeBlobs = databaseMetaData.doesMaxRowSizeIncludeBlobs();
        this.generatedKeyAlwaysReturned = databaseMetaData.generatedKeyAlwaysReturned();
        try {
            method = DatabaseMetaData.class.getMethod("catCatalogs", null);
            list = Retrievables.retrieve(Catalog.class, databaseMetaData, method, null);
            for (Retrievable element : list) {
                this.getCatalogs().put(((Catalog)element).getTableCat(), (Catalog)element);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
        this.catalogSeparator = databaseMetaData.getCatalogSeparator();
        this.catalogTerm = databaseMetaData.getCatalogTerm();
        try {
            method = DatabaseMetaData.class.getMethod("getClientInfoProperties", null);
            list = Retrievables.retrieve(ClientInfoProperty.class, databaseMetaData, method, null);
            for (Retrievable element : list) {
                this.getClientInfoProperties().put(((ClientInfoProperty)element).getName(), (ClientInfoProperty)element);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
    }

    public boolean deletesAreDetected(int type) {
        return this.deletesAreDetected.get(type);
    }

    public Map<String, Catalog> getCatalogs() {
        if (this.catalogs == null) {
            this.catalogs = new HashMap<String, Catalog>();
        }
        return this.catalogs;
    }

    public Map<String, ClientInfoProperty> getClientInfoProperties() {
        if (this.clientInfoProperties == null) {
            this.clientInfoProperties = new HashMap<String, ClientInfoProperty>();
        }
        return this.clientInfoProperties;
    }
}

