/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util;

public final class JinahyaCharacter {
    public static int[] codePoints(char[] a, int offset, int count) {
        int[] codePoints = new int[Character.codePointCount(a, offset, count)];
        int index = offset;
        for (int i = 0; i < codePoints.length; ++i) {
            codePoints[i] = Character.codePointAt(a, index);
            index += Character.charCount(codePoints[i]);
        }
        return codePoints;
    }

    public static int[] codePoints(CharSequence seq, int beginIndex, int endIndex) {
        int[] codePoints = new int[Character.codePointCount(seq, beginIndex, endIndex)];
        int index = beginIndex;
        for (int i = 0; i < codePoints.length; ++i) {
            codePoints[i] = Character.codePointAt(seq, index);
            index += Character.charCount(codePoints[i]);
        }
        return codePoints;
    }

    public static boolean isJavaIdentifier(int[] codePoints) {
        if (codePoints == null) {
            throw new NullPointerException("null codePoints");
        }
        if (codePoints.length == 0) {
            throw new IllegalArgumentException("empty codePoints");
        }
        if (!Character.isJavaIdentifierStart(codePoints[0])) {
            return false;
        }
        for (int i = 1; i < codePoints.length; ++i) {
            if (Character.isJavaIdentifierPart(codePoints[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isJavaIdentifier(CharSequence seq) {
        if (seq == null) {
            throw new NullPointerException("null seq");
        }
        if (seq.length() == 0) {
            throw new IllegalArgumentException("empty seq");
        }
        return JinahyaCharacter.isJavaIdentifier(JinahyaCharacter.codePoints(seq, 0, seq.length()));
    }

    public static boolean isJavaIdentifier(char[] a) {
        if (a == null) {
            throw new NullPointerException("null a");
        }
        if (a.length == 0) {
            throw new IllegalArgumentException("empty a");
        }
        return JinahyaCharacter.isJavaIdentifier(JinahyaCharacter.codePoints(a, 0, a.length));
    }

    private JinahyaCharacter() {
    }
}

