/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util;

import java.io.Serializable;
import java.util.Random;

public class JinahyaRandom
implements Serializable {
    private static final long serialVersionUID = 4093243768555129124L;
    private final Random random;

    public static int nextInt(Random random, int minimum, int maximum) {
        if (random == null) {
            throw new NullPointerException("random");
        }
        if (maximum < minimum) {
            throw new IllegalArgumentException("maximum(" + maximum + ") < minimum(" + minimum + ")");
        }
        long range = (long)maximum - (long)minimum;
        if (range > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("maximum(" + maximum + ") - minimum(" + minimum + ") = " + range + " > " + Integer.MAX_VALUE);
        }
        if (maximum == minimum) {
            return minimum;
        }
        return random.nextInt(maximum - minimum) + minimum;
    }

    public static byte[] nextBytes(Random random, int minimumLength, int maximumLength) {
        if (random == null) {
            throw new NullPointerException("random");
        }
        if (minimumLength < 0) {
            throw new IllegalArgumentException("minimumLength(" + minimumLength + ") < 0");
        }
        if (maximumLength < minimumLength) {
            throw new IllegalArgumentException("maximumLength(" + maximumLength + ") < minimumLength(" + minimumLength + ")");
        }
        int length = JinahyaRandom.nextInt(random, minimumLength, maximumLength);
        byte[] bytes = new byte[length];
        random.nextBytes(bytes);
        return bytes;
    }

    public JinahyaRandom(Random random) {
        if (random == null) {
            throw new NullPointerException("random");
        }
        this.random = random;
    }

    protected int nextInt(int minimum, int maximum) {
        if (maximum < minimum) {
            throw new IllegalArgumentException("maximum(" + maximum + ") < minimum(" + minimum + ")");
        }
        long range = (long)maximum - (long)minimum;
        if (range > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("range(" + range + ") > " + Integer.MAX_VALUE);
        }
        if (maximum == minimum) {
            return minimum;
        }
        return this.random.nextInt(maximum - minimum) + minimum;
    }

    public byte[] nextBytes(int minimumLength, int maximumLength) {
        if (minimumLength < 0) {
            throw new IllegalArgumentException("minimumLength(" + minimumLength + ") < 0");
        }
        if (maximumLength < minimumLength) {
            throw new IllegalArgumentException("maximumLength(" + maximumLength + ") < minimumLength(" + minimumLength + ")");
        }
        byte[] bytes = new byte[this.nextInt(minimumLength, maximumLength)];
        this.random.nextBytes(bytes);
        return bytes;
    }

    public int nextUnsignedInt(int minimumBitLength, int maximumBitLength) {
        if (minimumBitLength < 1) {
            throw new IllegalArgumentException("minimumBitLength(" + minimumBitLength + ") < 1");
        }
        if (maximumBitLength < minimumBitLength) {
            throw new IllegalArgumentException("maximumBitLength(" + maximumBitLength + ") < minimumBitLength(" + minimumBitLength + ")");
        }
        if (maximumBitLength >= 32) {
            throw new IllegalArgumentException("maximumBitLength(" + maximumBitLength + ") >= " + 32);
        }
        int bitLength = this.nextInt(minimumBitLength, maximumBitLength);
        int value = this.random.nextInt();
        value = value < 0 ? (value >>>= 32 - bitLength) : (value >>= 32 - bitLength - 1);
        return value;
    }

    public int nextSignedInt(int minimumBitLength, int maximumBitLength) {
        if (minimumBitLength <= 1) {
            throw new IllegalArgumentException("minimumBitLength(" + minimumBitLength + ") <= 1");
        }
        if (maximumBitLength < minimumBitLength) {
            throw new IllegalArgumentException("maximumBitLength(" + maximumBitLength + ") < miinimumBitLength(" + minimumBitLength + ")");
        }
        if (maximumBitLength > 32) {
            throw new IllegalArgumentException("maximumBitLength(" + maximumBitLength + ") > " + 32);
        }
        int bitLength = this.nextInt(minimumBitLength, maximumBitLength);
        int nextInt = this.random.nextInt();
        nextInt = (long)nextInt > 0L ? (nextInt >>= 32 - bitLength - 1) : (nextInt >>= 32 - bitLength);
        return nextInt;
    }

    public long nextUnsignedLong(int minimumBitLength, int maximumBitLength) {
        if (minimumBitLength < 1) {
            throw new IllegalArgumentException("minimumBitLength(" + minimumBitLength + ") < 1");
        }
        if (maximumBitLength < minimumBitLength) {
            throw new IllegalArgumentException("maximumBitLength(" + maximumBitLength + ") < minimumBitLength(" + minimumBitLength + ")");
        }
        if (maximumBitLength >= 64) {
            throw new IllegalArgumentException("maximumBitLength(" + maximumBitLength + ") >= " + 64);
        }
        int bitLength = this.nextInt(minimumBitLength, maximumBitLength);
        long value = this.random.nextLong();
        value = value < 0L ? (value >>>= 64 - bitLength) : (value >>= 64 - bitLength - 1);
        return value;
    }

    public long nextSignedLong(int minimumBitLength, int maximumBitLength) {
        if (minimumBitLength <= 1) {
            throw new IllegalArgumentException("minimumBitLength(" + minimumBitLength + ") <= 1");
        }
        if (maximumBitLength < minimumBitLength) {
            throw new IllegalArgumentException("maximumBitLength(" + maximumBitLength + ") < minimumBitLength(" + minimumBitLength + ")");
        }
        if (maximumBitLength > 64) {
            throw new IllegalArgumentException("maximumBitLength(" + maximumBitLength + ") > " + 64);
        }
        int bitLength = this.nextInt(minimumBitLength, maximumBitLength);
        long value = this.random.nextLong();
        value = value > 0L ? (value >>= 64 - bitLength - 1) : (value >>= 64 - bitLength);
        return value;
    }
}

