/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.logging;

import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Loggers {
    public static <H extends Handler> void setHandlersLevel(Logger logger, Class<H> type, Level level) {
        Logger parent;
        if (logger == null) {
            throw new NullPointerException("logger");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (level == null) {
            throw new NullPointerException("level");
        }
        if (logger.getUseParentHandlers() && (parent = logger.getParent()) != null) {
            Loggers.setHandlersLevel(parent, type, level);
            return;
        }
        for (Handler handler : logger.getHandlers()) {
            if (!type.isInstance(handler)) continue;
            handler.setLevel(level);
        }
    }

    public static void setConsoleHandlersLevel(Logger logger, Level level) {
        Loggers.setHandlersLevel(logger, ConsoleHandler.class, level);
    }

    public static void setConsoleHandlerLevel(Logger logger, Level level) {
        Logger parent;
        if (logger == null) {
            throw new NullPointerException("logger");
        }
        if (level == null) {
            throw new NullPointerException("level");
        }
        if (logger.getUseParentHandlers() && (parent = logger.getParent()) != null) {
            Loggers.setConsoleHandlerLevel(parent, level);
            return;
        }
        for (Handler handler : logger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            handler.setLevel(level);
            return;
        }
    }

    private Loggers() {
    }
}

