/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.zip;

import com.googlecode.jinahya.io.Streams;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Zips {
    protected static File file(File root, ZipEntry entry) throws IOException {
        String name;
        int index;
        File file;
        if (root == null) {
            throw new NullPointerException("root");
        }
        if (!root.isDirectory()) {
            throw new IllegalArgumentException("root is not an existing directory");
        }
        if (entry == null) {
            throw new NullPointerException("entry");
        }
        File parent = file = new File(root, entry.getName());
        if (!entry.isDirectory() && (index = (name = entry.getName()).lastIndexOf(47)) != -1) {
            parent = new File(root, name.substring(0, index));
        }
        if (parent != null && !parent.isDirectory() && !parent.mkdirs()) {
            throw new IOException("failed to create a directory: " + parent.getPath());
        }
        return file;
    }

    protected static void zip(StringBuilder path, File file, FileFilter filter, ZipOutputStream stream, byte[] buffer) throws IOException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("file does not exist");
        }
        if (filter == null) {
            // empty if block
        }
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (buffer.length == 0) {
            throw new IllegalArgumentException("buffer.length(" + buffer.length + ") == 0");
        }
        if (file.isDirectory()) {
            stream.putNextEntry(new ZipEntry(path + file.getName() + "/"));
            stream.closeEntry();
            int start = path.length();
            path.append(file.getName()).append("/");
            for (File child : file.listFiles()) {
                if (filter != null && !filter.accept(child)) continue;
                Zips.zip(path, child, filter, stream, buffer);
            }
            path.delete(start, path.length());
        } else {
            stream.putNextEntry(new ZipEntry(path + file.getName()));
            Streams.copy(file, (OutputStream)stream, buffer, -1L);
            stream.closeEntry();
        }
    }

    public static void zip(File directory, FileFilter filter, ZipOutputStream stream, byte[] buffer) throws IOException {
        if (directory == null) {
            throw new NullPointerException("directory");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("directory doesn't exist");
        }
        if (filter == null) {
            // empty if block
        }
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (buffer.length == 0) {
            throw new IllegalArgumentException("buffer.length(" + buffer.length + ") == 0");
        }
        StringBuilder path = new StringBuilder();
        for (File file : directory.listFiles()) {
            if (filter != null && !filter.accept(file)) continue;
            Zips.zip(path, file, filter, stream, buffer);
        }
    }

    public static void unzip(ZipInputStream stream, File directory, byte[] buffer) throws IOException {
        ZipEntry entry;
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (directory == null) {
            throw new NullPointerException("directory");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("directory doesn't exist");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (buffer.length == 0) {
            throw new IllegalArgumentException("buffer.length(" + buffer.length + ") == 0");
        }
        while ((entry = stream.getNextEntry()) != null) {
            File file = Zips.file(directory, entry);
            if (!entry.isDirectory()) {
                Streams.copy((InputStream)stream, file, buffer, -1L);
            }
            stream.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(ZipFile zipfile, File directory, byte[] buffer) throws IOException {
        if (zipfile == null) {
            throw new NullPointerException("zipfile");
        }
        if (directory == null) {
            throw new NullPointerException("directory");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("directory doesn't exist");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (buffer.length == 0) {
            throw new IllegalArgumentException("buffer.length(" + buffer.length + ") == 0");
        }
        Enumeration<? extends ZipEntry> entries = zipfile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File file = Zips.file(directory, entry);
            if (entry.isDirectory()) continue;
            InputStream input = zipfile.getInputStream(entry);
            try {
                Streams.copy(input, file, buffer, -1L);
            }
            finally {
                input.close();
            }
        }
    }

    protected Zips() {
    }
}

