/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.xml.bind;

import com.googlecode.jinahya.xml.bind.MapEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public abstract class MapEntries<T extends MapEntry<K, V>, K, V> {
    private static final Logger LOGGER = Logger.getLogger(MapEntries.class.getName());
    protected final Class<T> entryType;
    private List<T> entries;

    public MapEntries(Class<T> entryType) {
        if (entryType == null) {
            throw new NullPointerException("entryType");
        }
        this.entryType = entryType;
    }

    public Class<T> getEntryType() {
        return this.entryType;
    }

    protected List<T> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<T>();
        }
        return this.entries;
    }

    public void addEntry(K key, V value) {
        MapEntry entry;
        try {
            entry = (MapEntry)this.entryType.newInstance();
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        entry.setKey(key);
        entry.setValue(value);
        this.getEntries().add(entry);
    }

    public void addEntry(Map.Entry<K, V> entry) {
        if (entry == null) {
            throw new NullPointerException("entry");
        }
        this.addEntry(entry.getKey(), entry.getValue());
    }

    public void addEntries(Map<K, V> map) {
        if (map == null) {
            throw new NullPointerException("map");
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.addEntry(entry);
        }
    }

    static {
        LOGGER.setLevel(Level.INFO);
    }
}

