/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.xml.bind;

import com.googlecode.jinahya.xml.bind.MapEntries;
import com.googlecode.jinahya.xml.bind.MapEntry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public abstract class MapEntriesAdapter<T extends MapEntries<?, K, V>, K, V>
extends XmlAdapter<T, Map<K, V>> {
    private static final Logger LOGGER = Logger.getLogger(MapEntriesAdapter.class.getName());
    private final Class<T> entriesType;

    public MapEntriesAdapter(Class<T> entriesType) {
        if (entriesType == null) {
            throw new NullPointerException("entriesType");
        }
        this.entriesType = entriesType;
    }

    public Map<K, V> unmarshal(T value) throws Exception {
        LOGGER.log(Level.INFO, "unmarshal({0})", value);
        if (value == null) {
            return null;
        }
        List ventries = ((MapEntries)value).getEntries();
        HashMap bound = new HashMap(ventries.size());
        for (MapEntry ventry : ventries) {
            bound.put(ventry.getKey(), ventry.getValue());
        }
        LOGGER.log(Level.INFO, "bound: {0}", bound);
        return bound;
    }

    public T marshal(Map<K, V> bound) throws Exception {
        if (bound == null) {
            return null;
        }
        MapEntries value = (MapEntries)this.entriesType.newInstance();
        value.addEntries(bound);
        return (T)value;
    }

    static {
        LOGGER.setLevel(Level.INFO);
    }
}

