/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.xml.bind;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class Marshallers {
    private static final Map<Class<?>, Method> MARSHAL_METHODS;

    public static <T> void marshal(Marshaller marshaller, Object value, Class<? super T> outputType, T output) throws JAXBException {
        if (marshaller == null) {
            throw new NullPointerException("marshaller");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (outputType == null) {
            throw new NullPointerException("outputType");
        }
        if (output == null) {
            throw new NullPointerException("output");
        }
        Method method = MARSHAL_METHODS.get(outputType);
        if (method == null) {
            throw new IllegalArgumentException("can't marshal to " + outputType);
        }
        try {
            method.invoke((Object)marshaller, value, output);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (JAXBException.class.isInstance(cause)) {
                throw (JAXBException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static <T> void marshal(JAXBContext context, Object value, Class<? super T> outputType, T output) throws JAXBException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        Marshallers.marshal(context.createMarshaller(), value, outputType, output);
    }

    public static <T> void marshal(Object value, Class<? super T> outputType, T output) throws JAXBException {
        if (value == null) {
            throw new NullPointerException("value");
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{value.getClass()});
        Marshallers.marshal(context, value, outputType, output);
    }

    public static void marshal(Marshaller marshaller, Object value, Object output) throws JAXBException {
        if (marshaller == null) {
            throw new NullPointerException("marshaller");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (output == null) {
            throw new NullPointerException("output");
        }
        Method method = null;
        for (Map.Entry<Class<?>, Method> entry : MARSHAL_METHODS.entrySet()) {
            if (!entry.getKey().isAssignableFrom(output.getClass())) continue;
            method = entry.getValue();
            break;
        }
        if (method == null) {
            throw new IllegalArgumentException("can't marshal to " + output.getClass());
        }
        try {
            method.invoke((Object)marshaller, value, output);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (JAXBException.class.isInstance(cause)) {
                throw (JAXBException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static void marshal(JAXBContext context, Object value, Object output) throws JAXBException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        Marshallers.marshal(context.createMarshaller(), value, output);
    }

    public static void marshal(Object value, Object output) throws JAXBException {
        if (value == null) {
            throw new NullPointerException("value");
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{value.getClass()});
        Marshallers.marshal(context, value, output);
    }

    protected Marshallers() {
    }

    static {
        HashMap methods = new HashMap();
        for (Method method : Marshaller.class.getMethods()) {
            Class<?>[] parameterTypes;
            Class<?> returnType;
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) || !Void.TYPE.equals(returnType = method.getReturnType()) || !"marshal".equals(method.getName()) || (parameterTypes = method.getParameterTypes()).length != 2 || !Object.class.equals(parameterTypes[0])) continue;
            methods.put(parameterTypes[1], method);
        }
        MARSHAL_METHODS = Collections.unmodifiableMap(methods);
    }
}

