/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.xml.bind;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;

public class Unmarshallers {
    private static final Map<Class<?>, Method> UNMARSHAL_METHODS;
    private static final Map<Class<?>, Method> DECLARED_UNMARSHAL_METHODS;

    public static <I> Object unmarshal(Unmarshaller unmarshaller, Class<? super I> inputType, I input) throws UnmarshalException {
        if (unmarshaller == null) {
            throw new NullPointerException("unmarshaller");
        }
        if (inputType == null) {
            throw new NullPointerException("inputType");
        }
        if (input == null) {
            throw new NullPointerException("input");
        }
        Method method = UNMARSHAL_METHODS.get(inputType);
        if (method == null) {
            throw new IllegalArgumentException("can't unmarshal from " + inputType);
        }
        try {
            return method.invoke((Object)unmarshaller, input);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (UnmarshalException.class.isInstance(cause)) {
                throw (UnmarshalException)cause;
            }
            throw new RuntimeException(ite);
        }
    }

    public static <I> Object unmarshal(JAXBContext context, Class<? super I> inputType, I input) throws JAXBException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        return Unmarshallers.unmarshal(context.createUnmarshaller(), inputType, input);
    }

    public static Object unmarshal(Unmarshaller unmarshaller, Object input) throws UnmarshalException {
        if (unmarshaller == null) {
            throw new NullPointerException("unmarshaller");
        }
        if (input == null) {
            throw new NullPointerException("input");
        }
        Class<?> inputType = input.getClass();
        Method method = null;
        for (Map.Entry<Class<?>, Method> entry : UNMARSHAL_METHODS.entrySet()) {
            if (!entry.getKey().isAssignableFrom(inputType)) continue;
            method = entry.getValue();
            break;
        }
        if (method == null) {
            throw new IllegalArgumentException("can't unmarshal from " + inputType);
        }
        try {
            return method.invoke((Object)unmarshaller, input);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (UnmarshalException.class.isInstance(cause)) {
                throw (UnmarshalException)cause;
            }
            throw new RuntimeException(ite);
        }
    }

    public static Object unmarshal(JAXBContext context, Object input) throws JAXBException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        return Unmarshallers.unmarshal(context.createUnmarshaller(), input);
    }

    public static <I, V> JAXBElement<V> unmarshal(Unmarshaller unmarshaller, Class<? super I> inputType, I input, Class<V> valueType) throws UnmarshalException {
        if (unmarshaller == null) {
            throw new NullPointerException("unmarshaller");
        }
        if (inputType == null) {
            throw new NullPointerException("inputType");
        }
        if (input == null) {
            throw new NullPointerException("input");
        }
        if (valueType == null) {
            throw new NullPointerException("valueType");
        }
        Method method = DECLARED_UNMARSHAL_METHODS.get(inputType);
        if (method == null) {
            throw new IllegalArgumentException("can't unmarshal from " + input.getClass());
        }
        try {
            JAXBElement result = (JAXBElement)method.invoke((Object)unmarshaller, input, valueType);
            return result;
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (UnmarshalException.class.isInstance(cause)) {
                throw (UnmarshalException)cause;
            }
            throw new RuntimeException(ite);
        }
    }

    public static <I, V> JAXBElement<V> unmarshal(JAXBContext context, Class<? super I> inputType, I input, Class<V> valueType) throws JAXBException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        return Unmarshallers.unmarshal(context.createUnmarshaller(), input, valueType);
    }

    public static <I, V> JAXBElement<V> unmarshal(Class<? super I> inputType, I input, Class<V> valueType) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{valueType});
        return Unmarshallers.unmarshal(context, input, valueType);
    }

    public static <V> JAXBElement<V> unmarshal(Unmarshaller unmarshaller, Object input, Class<V> valueType) throws UnmarshalException {
        if (unmarshaller == null) {
            throw new NullPointerException("unmarshaller");
        }
        if (input == null) {
            throw new NullPointerException("input");
        }
        if (valueType == null) {
            throw new NullPointerException("valueType");
        }
        Class<?> inputType = input.getClass();
        Method method = null;
        for (Map.Entry<Class<?>, Method> entry : DECLARED_UNMARSHAL_METHODS.entrySet()) {
            if (!entry.getKey().isAssignableFrom(inputType)) continue;
            method = entry.getValue();
            break;
        }
        if (method == null) {
            throw new IllegalArgumentException("can't unmarshal from " + inputType);
        }
        try {
            JAXBElement result = (JAXBElement)method.invoke((Object)unmarshaller, input, valueType);
            return result;
        }
        catch (IllegalAccessException iae) {
            throw new UnmarshalException((Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof UnmarshalException) {
                throw (UnmarshalException)cause;
            }
            throw new UnmarshalException(cause);
        }
    }

    public static <V> JAXBElement<V> unmarshal(JAXBContext context, Object input, Class<V> valueType) throws JAXBException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        return Unmarshallers.unmarshal(context.createUnmarshaller(), input, valueType);
    }

    public static <V> JAXBElement<V> unmarshal(Object input, Class<V> valueType) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{valueType});
        return Unmarshallers.unmarshal(context, input, valueType);
    }

    protected Unmarshallers() {
    }

    static {
        Class<?>[] parameterTypes;
        Class<?> returnType;
        int modifiers;
        HashMap methods = new HashMap();
        for (Method method : Unmarshaller.class.getMethods()) {
            modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) || !Object.class.equals(returnType = method.getReturnType()) || "unmarshal".equals(method.getName()) || (parameterTypes = method.getParameterTypes()).length != 1) continue;
            methods.put(parameterTypes[0], method);
        }
        UNMARSHAL_METHODS = Collections.unmodifiableMap(methods);
        methods = new HashMap();
        for (Method method : Unmarshaller.class.getMethods()) {
            modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) || !JAXBElement.class.equals(returnType = method.getReturnType()) || !"unmarshal".equals(method.getName()) || (parameterTypes = method.getParameterTypes()).length != 2 || !Class.class.equals(parameterTypes[1]) || !returnType.getTypeParameters()[0].getName().equals(parameterTypes[1].getTypeParameters()[0].getName())) continue;
            methods.put(parameterTypes[0], method);
        }
        DECLARED_UNMARSHAL_METHODS = Collections.unmodifiableMap(methods);
    }
}

