/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.xml.bind;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public abstract class ValuesMapAdapter<T extends Values<V>, K, V>
extends XmlAdapter<T, Map<K, V>> {
    private final Class<T> valueType;

    public ValuesMapAdapter(Class<T> valueType) {
        if (valueType == null) {
            throw new NullPointerException("valueType");
        }
        this.valueType = valueType;
    }

    public Map<K, V> unmarshal(T v) throws Exception {
        if (v == null) {
            return null;
        }
        HashMap b = new HashMap(v.getValueList().size());
        for (Object value : v.getValueList()) {
            b.put(this.getKey(value), value);
        }
        return b;
    }

    public T marshal(Map<K, V> b) throws Exception {
        if (b == null) {
            return null;
        }
        Values v = (Values)this.valueType.newInstance();
        for (V value : b.values()) {
            v.getValueList().add(value);
        }
        return (T)v;
    }

    protected Map<K, V> newBoundType(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    protected abstract K getKey(V var1);

    @XmlTransient
    public static abstract class AbstractValues<V>
    implements Values<V> {
        @XmlTransient
        private List<V> valueList;

        @Override
        @XmlTransient
        public List<V> getValueList() {
            if (this.valueList == null) {
                this.valueList = new ArrayList<V>();
            }
            return this.valueList;
        }
    }

    @XmlTransient
    public static interface Values<V> {
        @XmlTransient
        public List<V> getValueList();
    }
}

