/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.xml.namespace;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import javax.xml.namespace.NamespaceContext;

public abstract class AbstractNamespaceContext
implements NamespaceContext {
    protected static boolean isReservedPrefix(String prefix) {
        Objects.requireNonNull(prefix, "null prefix");
        return "".equals(prefix) || "xml".equals(prefix) || "xmlns".equals(prefix);
    }

    protected static boolean isReservedNamespaceURI(String namespaceURI) {
        Objects.requireNonNull(namespaceURI, "null namespaceURI");
        return "".equals(namespaceURI) || "http://www.w3.org/XML/1998/namespace".equals(namespaceURI) || "http://www.w3.org/2000/xmlns/".equals(namespaceURI);
    }

    protected static String getReservedNamespaceURI(String prefix) {
        Objects.requireNonNull(prefix, "null prefix");
        if ("".equals(prefix)) {
            return "";
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        throw new IllegalArgumentException("not predefined");
    }

    protected static String getReservedPrefix(String namespaceURI) {
        Objects.requireNonNull(namespaceURI, "null namespaceURI");
        if ("".equals(namespaceURI)) {
            return "";
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            return "xmlns";
        }
        throw new IllegalArgumentException("not predefined");
    }

    public Iterator getPrefixes(String namespaceURI) {
        Objects.requireNonNull(namespaceURI, "null namespaceURI");
        String prefix = this.getPrefix(namespaceURI);
        if (prefix == null) {
            return Collections.emptyIterator();
        }
        return Collections.singleton(prefix).iterator();
    }
}

