/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.xml.namespace;

import java.util.Collections;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;

public class VerySimpleNamespaceContext
implements NamespaceContext {
    private final String prefix;
    private final String namespaceURI;
    private final String defaultNamespaceURI;

    public VerySimpleNamespaceContext(String prefix, String namespaceURI) {
        this(prefix, namespaceURI, null);
    }

    public VerySimpleNamespaceContext(String prefix, String namespaceURI, String defaultNamespaceURI) {
        if (prefix == null) {
            throw new NullPointerException("null prefix");
        }
        if (namespaceURI == null) {
            throw new NullPointerException("null namespaceURI");
        }
        this.prefix = prefix;
        this.namespaceURI = namespaceURI;
        this.defaultNamespaceURI = defaultNamespaceURI;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new NullPointerException("null prefix");
        }
        if ("".equals(prefix)) {
            if (this.defaultNamespaceURI != null) {
                return this.defaultNamespaceURI;
            }
            return "";
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (this.prefix.equals(prefix)) {
            return this.namespaceURI;
        }
        return "";
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("null namespaceURI");
        }
        if (this.defaultNamespaceURI != null && this.defaultNamespaceURI.equals(namespaceURI)) {
            return "";
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            return "xmlns";
        }
        if (this.namespaceURI.equals(namespaceURI)) {
            return this.prefix;
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("null namespaceURI");
        }
        String prefix = this.getPrefix(namespaceURI);
        if (prefix == null) {
            return Collections.emptyIterator();
        }
        return Collections.singletonList(prefix).iterator();
    }
}

