/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.nica;

import com.googlecode.jinahya.nica.Code;
import com.googlecode.jinahya.nica.util.Aes;
import com.googlecode.jinahya.nica.util.Hac;
import com.googlecode.jinahya.nica.util.Hex;
import com.googlecode.jinahya.nica.util.Par;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public abstract class Headers {
    private static final Random RANDOM = new SecureRandom();
    private final String name;
    private final Aes aes;
    private final Hac mac;
    private final Map constantCodes = new HashMap();
    private final transient Map variableCodes = new HashMap();

    protected Headers(String name, Aes aes, Hac mac) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (aes == null) {
            throw new IllegalArgumentException("null aes");
        }
        if (mac == null) {
            throw new IllegalArgumentException("null mac");
        }
        this.name = name;
        this.aes = aes;
        this.mac = mac;
    }

    protected Map getHeaders() {
        byte[] base;
        HashMap<String, String> headers = new HashMap<String, String>(4);
        headers.put("Nica-Name", this.name);
        byte[] iv = new byte[16];
        RANDOM.nextBytes(iv);
        headers.put("Nica-Init", Hex.encodeToString(iv));
        this.variableCodes.put(Code.SYSTEM_MILLIS.name(), Long.toString(System.currentTimeMillis()));
        HashMap<String, String> codes = new HashMap<String, String>(this.constantCodes.size() + this.variableCodes.size());
        codes.putAll(this.constantCodes);
        codes.putAll(this.variableCodes);
        this.variableCodes.clear();
        try {
            base = Par.encode(codes).getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("\"US-ASCII\" is not supported?");
        }
        byte[] code = this.aes.encrypt(iv, base);
        headers.put("Nica-Code", Hex.encodeToString(code));
        byte[] auth = this.mac.authenticate(base);
        headers.put("Nica-Auth", Hex.encodeToString(auth));
        return headers;
    }

    public void setHeaders(URLConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("null connection");
        }
        for (Map.Entry entry : this.getHeaders().entrySet()) {
            String fieldName = (String)entry.getKey();
            String fieldValue = (String)entry.getValue();
            connection.setRequestProperty(fieldName, fieldValue);
        }
    }

    public void putConstantCode(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        if (this.constantCodes.containsKey(key)) {
            throw new IllegalArgumentException("key(" + key + ") is already oocupied");
        }
        this.constantCodes.put(key, value);
    }

    public String putVariableCode(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        return this.variableCodes.put(key, value);
    }
}

