/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.nica.util;

import com.googlecode.jinahya.nica.util.Hac;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

public class HacBC
extends Hac {
    private final KeyParameter keyParameter;

    public HacBC(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (key.length != 16) {
            throw new IllegalArgumentException("key.length(" + key.length + ") != " + 16);
        }
        this.keyParameter = new KeyParameter(key);
    }

    @Override
    public byte[] authenticate(byte[] message) {
        if (message == null) {
            throw new IllegalArgumentException("null message");
        }
        HMac mac = new HMac((Digest)new SHA512Digest());
        mac.init((CipherParameters)this.keyParameter);
        mac.update(message, 0, message.length);
        byte[] authenticated = new byte[mac.getMacSize()];
        mac.doFinal(authenticated, 0);
        return authenticated;
    }
}

