/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.nica.util;

import com.googlecode.jinahya.nica.util.Hac;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HacJCE
extends Hac {
    private static final String ALGORITHM = "HmacSHA512";
    private final Key key;

    public HacJCE(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (key.length != 16) {
            throw new IllegalArgumentException("key.length(" + key.length + ") != " + 16);
        }
        this.key = new SecretKeySpec(key, ALGORITHM);
    }

    @Override
    public byte[] authenticate(byte[] message) {
        if (message == null) {
            throw new IllegalArgumentException("null unauthenticated");
        }
        try {
            Mac mac = Mac.getInstance(ALGORITHM);
            try {
                mac.init(this.key);
                return mac.doFinal(message);
            }
            catch (InvalidKeyException ike) {
                throw new RuntimeException(ike);
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("\"HmacSHA512\" is not supported?", nsae);
        }
    }
}

