/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.nica.util;

import com.googlecode.jinahya.nica.util.Sha;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ShaJCA
extends Sha {
    public static final String ALGORITHM = "SHA-512";

    public static Sha newSynchronizedInstance() {
        MessageDigest DIGEST;
        try {
            DIGEST = MessageDigest.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InstantiationError(nsae.getMessage());
        }
        return new ShaJCA(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] hash(byte[] data) {
                if (data == null) {
                    throw new IllegalArgumentException("null data");
                }
                MessageDigest messageDigest = DIGEST;
                synchronized (messageDigest) {
                    DIGEST.reset();
                    return DIGEST.digest(data);
                }
            }
        };
    }

    @Override
    public byte[] hash(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("null data");
        }
        try {
            return MessageDigest.getInstance(ALGORITHM).digest(data);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("\"SHA-512\" not available?");
        }
    }
}

