/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.nica.util;

import com.googlecode.jinahya.nica.util.Aes;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class AesBC
extends Aes {
    private final KeyParameter keyParameter;
    private final BufferedBlockCipher cipher;

    public AesBC(byte[] key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (key.length != 16) {
            throw new IllegalArgumentException("key.length(" + key.length + ") != " + 16);
        }
        this.keyParameter = new KeyParameter(key);
        this.cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESFastEngine()));
    }

    @Override
    public byte[] encrypt(byte[] iv, byte[] decrypted) {
        if (iv == null) {
            throw new NullPointerException("iv");
        }
        if (iv.length != 16) {
            throw new IllegalArgumentException("iv.length(" + iv.length + ") != " + 16);
        }
        if (decrypted == null) {
            throw new NullPointerException("decrypted");
        }
        this.cipher.reset();
        this.cipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)this.keyParameter, iv));
        byte[] encrypted = new byte[this.cipher.getOutputSize(decrypted.length)];
        int offset = this.cipher.processBytes(decrypted, 0, decrypted.length, encrypted, 0);
        try {
            offset += this.cipher.doFinal(encrypted, offset);
        }
        catch (InvalidCipherTextException icte) {
            throw new RuntimeException(icte.getMessage());
        }
        if (offset < encrypted.length) {
            byte[] trimmed = new byte[offset];
            System.arraycopy(encrypted, 0, trimmed, 0, offset);
            return trimmed;
        }
        return encrypted;
    }

    @Override
    public byte[] decrypt(byte[] iv, byte[] encrypted) {
        if (iv == null) {
            throw new NullPointerException("iv");
        }
        if (iv.length != 16) {
            throw new IllegalArgumentException("iv.length(" + iv.length + ") != " + 16);
        }
        if (encrypted == null) {
            throw new NullPointerException("encrypted");
        }
        this.cipher.reset();
        this.cipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)this.keyParameter, iv));
        byte[] decrypted = new byte[this.cipher.getOutputSize(encrypted.length)];
        int offset = this.cipher.processBytes(encrypted, 0, encrypted.length, decrypted, 0);
        try {
            offset += this.cipher.doFinal(decrypted, offset);
        }
        catch (InvalidCipherTextException icte) {
            throw new RuntimeException(icte.getMessage());
        }
        if (offset < decrypted.length) {
            byte[] trimmed = new byte[offset];
            System.arraycopy(decrypted, 0, trimmed, 0, offset);
            return trimmed;
        }
        return decrypted;
    }
}

