/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.nica.util;

import com.googlecode.jinahya.nica.util.Hac;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

public class HacBC
extends Hac {
    private final HMac mac;

    public HacBC(byte[] key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (key.length != 16) {
            throw new IllegalArgumentException("key.length(" + key.length + ") != " + 16);
        }
        this.mac = new HMac((Digest)new SHA1Digest());
        this.mac.init((CipherParameters)new KeyParameter(key));
    }

    @Override
    public byte[] authenticate(byte[] message) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        byte[] output = new byte[this.mac.getMacSize()];
        this.mac.reset();
        this.mac.update(message, 0, message.length);
        this.mac.doFinal(output, 0);
        return output;
    }
}

