/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.nica.util;

import com.googlecode.jinahya.nica.util.Hac;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HacJCE
extends Hac {
    private static final String ALGORITHM = "HmacSHA1";
    private final Mac mac;

    public HacJCE(byte[] key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (key.length != 16) {
            throw new IllegalArgumentException("key.length(" + key.length + ") != " + 16);
        }
        try {
            this.mac = Mac.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("\"HmacSHA1\" is not supported?", nsae);
        }
        try {
            this.mac.init(new SecretKeySpec(key, ALGORITHM));
        }
        catch (InvalidKeyException ike) {
            throw new RuntimeException(ike);
        }
    }

    @Override
    public byte[] authenticate(byte[] message) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        return this.mac.doFinal(message);
    }
}

