/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.nica.util;

import java.io.UnsupportedEncodingException;

public class Hex {
    private static int encodeHalf(int decoded) {
        switch (decoded) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return decoded + 48;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return decoded + 55;
            }
        }
        throw new IllegalArgumentException("illegal half: " + decoded);
    }

    protected static void encodeSingle(int decoded, byte[] encoded, int offset) {
        if (decoded < 0) {
            throw new IllegalArgumentException("decoded(" + decoded + ") < 0x00");
        }
        if (decoded > 255) {
            throw new IllegalArgumentException("decoded(" + decoded + ") > 0xFF");
        }
        if (encoded == null) {
            throw new IllegalArgumentException("null encoded");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset(" + offset + ") < 0");
        }
        if (offset >= encoded.length - 1) {
            throw new IllegalArgumentException("offset(" + offset + ") >= encoded.length(" + encoded.length + ") - 1");
        }
        encoded[offset] = (byte)Hex.encodeHalf(decoded >> 4 & 0xF);
        encoded[offset + 1] = (byte)Hex.encodeHalf(decoded & 0xF);
    }

    public static byte[] encode(byte[] decoded) {
        if (decoded == null) {
            throw new NullPointerException("decoded");
        }
        byte[] encoded = new byte[decoded.length << 1];
        int offset = 0;
        for (int i = 0; i < decoded.length; ++i) {
            Hex.encodeSingle(decoded[i] & 0xFF, encoded, offset);
            offset += 2;
        }
        return encoded;
    }

    public static byte[] encode(String decoded) {
        if (decoded == null) {
            throw new IllegalArgumentException("null decoded");
        }
        try {
            return Hex.encode(decoded.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("\"UTF-8\" not supported?");
        }
    }

    public static String encodeToString(byte[] decoded) {
        if (decoded == null) {
            throw new NullPointerException("null decoded");
        }
        try {
            return new String(Hex.encode(decoded), "US-ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("\"US-ASCII\" is not supported?");
        }
    }

    public static String encodeToString(String decoded) {
        if (decoded == null) {
            throw new NullPointerException("decoded");
        }
        try {
            return new String(Hex.encode(decoded), "US-ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("\"US-ASCII\" is not supported?", uee);
        }
    }

    public static byte[] enfast(byte[] decoded) {
        if (decoded == null) {
            throw new NullPointerException("decoded");
        }
        byte[] encoded = new byte[decoded.length << 1];
        int offset = 0;
        for (int i = 0; i < decoded.length; ++i) {
            int h = decoded[i] >> 4 & 0xF;
            int l = decoded[i] & 0xF;
            encoded[offset++] = (byte)(h + (h < 10 ? 48 : 55));
            encoded[offset++] = (byte)(l + (l < 10 ? 48 : 55));
        }
        return encoded;
    }

    public static byte[] enfast(String decoded) {
        if (decoded == null) {
            throw new NullPointerException("decoded");
        }
        try {
            return Hex.enfast(decoded.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("\"UTF_8\" is not supported?", uee);
        }
    }

    public static String enfastToString(byte[] decoded) {
        try {
            return new String(Hex.enfast(decoded), "US-ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("\"US-ASCII\" is not supported?", uee);
        }
    }

    public static String enfastToString(String decoded) {
        try {
            return new String(Hex.enfast(decoded), "US-ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("\"US-ASCII\" is not supported?", uee);
        }
    }

    private static int decodeHalf(int encoded) {
        switch (encoded) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return encoded - 48;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return encoded - 55;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return encoded - 87;
            }
        }
        throw new IllegalArgumentException("illegal half: " + encoded);
    }

    protected static int decodeSingle(byte[] encoded, int offset) {
        if (encoded == null) {
            throw new IllegalArgumentException("encoded");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset(" + offset + ") < 0");
        }
        if (offset >= encoded.length - 1) {
            throw new IllegalArgumentException("offset(" + offset + ") >= encoded.length(" + encoded.length + ") - 1");
        }
        return Hex.decodeHalf(encoded[offset]) << 4 | Hex.decodeHalf(encoded[offset + 1]);
    }

    public static byte[] decode(byte[] encoded) {
        if (encoded == null) {
            throw new NullPointerException("encoded");
        }
        if ((encoded.length & 1) == 1) {
            throw new IllegalArgumentException("encoded.length(" + encoded.length + ") is not even");
        }
        byte[] decoded = new byte[encoded.length >> 1];
        int offset = 0;
        for (int i = 0; i < decoded.length; ++i) {
            decoded[i] = (byte)Hex.decodeSingle(encoded, offset);
            offset += 2;
        }
        return decoded;
    }

    public static byte[] decode(String encoded) {
        if (encoded == null) {
            throw new NullPointerException("encoded");
        }
        try {
            return Hex.decode(encoded.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("\"US-ASCII\" is not supported?");
        }
    }

    public static String decodeToString(byte[] encoded) {
        try {
            return new String(Hex.decode(encoded), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("\"UTF-8\" is not supported?");
        }
    }

    public static String decodeToString(String encoded) {
        try {
            return Hex.decodeToString(encoded.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("\"US-ASCII\" is not supported?");
        }
    }

    public static byte[] defast(byte[] encoded) {
        if (encoded == null) {
            throw new NullPointerException("encoded");
        }
        byte[] decoded = new byte[encoded.length >> 1];
        int offset = 0;
        for (int i = 0; i < decoded.length; ++i) {
            int h = encoded[offset] - (encoded[offset] <= 57 ? 48 : (encoded[offset] <= 70 ? 55 : 87));
            int l = encoded[++offset] - (encoded[offset] <= 57 ? 48 : (encoded[offset] <= 70 ? 55 : 87));
            ++offset;
            decoded[i] = (byte)(h << 4 | l);
        }
        return decoded;
    }

    public static byte[] defast(String encoded) {
        if (encoded == null) {
            throw new NullPointerException("encoded");
        }
        try {
            return Hex.defast(encoded.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("\"US-ASCII\" is not supported? ", uee);
        }
    }

    public static String defastToString(byte[] encoded) {
        if (encoded == null) {
            throw new NullPointerException("encoded");
        }
        try {
            return new String(Hex.defast(encoded), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("\"UTF-8\" is not supported? ", uee);
        }
    }

    public static String defastToString(String encoded) {
        if (encoded == null) {
            throw new NullPointerException("encoded");
        }
        try {
            return new String(Hex.defast(encoded), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("\"UTF-8\" is not supported? ", uee);
        }
    }

    protected Hex() {
    }
}

