/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.nica.util;

import java.util.Random;

public abstract class Aes {
    public static final int KEY_SIZE = 256;
    public static final int KEY_SIZE_IN_BYTES = 32;
    public static final int BLOCK_SIZE = 128;
    public static final int BLOCK_SIZE_IN_BYTES = 16;
    public static final String ALGORITHM = "AES";
    public static final String MODE = "CBC";
    public static final String PADDING = "PKCS5Padding";
    public static final String TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final Random RANDOM = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] newIv() {
        byte[] iv = new byte[16];
        Random random = RANDOM;
        synchronized (random) {
            for (int i = 0; i < iv.length; ++i) {
                iv[i] = (byte)RANDOM.nextInt(256);
            }
        }
        return iv;
    }

    public static Aes synchronizedAes(Aes aes) {
        if (aes == null) {
            throw new IllegalArgumentException("null aes");
        }
        return new SynchronizedAes(aes);
    }

    public abstract byte[] encrypt(byte[] var1, byte[] var2);

    public abstract byte[] decrypt(byte[] var1, byte[] var2);

    private static class SynchronizedAes
    extends Aes {
        private final Aes aes;

        public SynchronizedAes(Aes aes) {
            if (aes == null) {
                throw new IllegalArgumentException("null aes");
            }
            this.aes = aes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] encrypt(byte[] iv, byte[] decrypted) {
            Aes aes = this.aes;
            synchronized (aes) {
                return this.aes.encrypt(iv, decrypted);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] decrypt(byte[] iv, byte[] encrypted) {
            Aes aes = this.aes;
            synchronized (aes) {
                return this.aes.decrypt(iv, encrypted);
            }
        }
    }
}

