/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.nica.util;

import com.googlecode.jinahya.nica.util.Aes;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesJCE
extends Aes {
    private final Key key;
    private final Cipher cipher;

    public static Aes newSynchronizedInstance(byte[] key) {
        return AesJCE.synchronizedAes(new AesJCE(key));
    }

    public AesJCE(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (key.length != 32) {
            throw new IllegalArgumentException("key.length(" + key.length + ") != " + 32);
        }
        this.key = new SecretKeySpec(key, "AES");
        try {
            this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("\"AES\" not supported?", nsae);
        }
        catch (NoSuchPaddingException nspe) {
            throw new RuntimeException("\"PKCS5Padding\" not supported?", nspe);
        }
    }

    @Override
    public byte[] encrypt(byte[] iv, byte[] decrypted) {
        if (iv == null) {
            throw new IllegalArgumentException("null iv");
        }
        if (iv.length != 16) {
            throw new IllegalArgumentException("iv.length(" + iv.length + ") != " + 16);
        }
        if (decrypted == null) {
            throw new IllegalArgumentException("null decrypted");
        }
        try {
            this.cipher.init(1, this.key, new IvParameterSpec(iv));
        }
        catch (InvalidKeyException ike) {
            throw new RuntimeException(ike);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new RuntimeException(iape);
        }
        try {
            return this.cipher.doFinal(decrypted);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new RuntimeException(ibse);
        }
        catch (BadPaddingException bpe) {
            throw new RuntimeException(bpe);
        }
    }

    @Override
    public byte[] decrypt(byte[] iv, byte[] encrypted) {
        if (iv == null) {
            throw new IllegalArgumentException("null iv");
        }
        if (iv.length != 16) {
            throw new IllegalArgumentException("iv.length(" + iv.length + ") != " + 16);
        }
        if (encrypted == null) {
            throw new IllegalArgumentException("null encrypted");
        }
        try {
            this.cipher.init(2, this.key, new IvParameterSpec(iv));
        }
        catch (InvalidKeyException ike) {
            throw new RuntimeException(ike);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new RuntimeException(iape);
        }
        try {
            return this.cipher.doFinal(encrypted);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new RuntimeException(ibse);
        }
        catch (BadPaddingException bpe) {
            throw new RuntimeException(bpe);
        }
    }
}

