/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.nica.util;

import com.googlecode.jinahya.nica.util.Hex;
import java.io.UnsupportedEncodingException;

public abstract class Hac {
    public static Hac synchronizedHac(Hac hac) {
        if (hac == null) {
            throw new IllegalArgumentException("null hac");
        }
        return new SynchronizedHac(hac);
    }

    public abstract byte[] authenticate(byte[] var1);

    public byte[] authenticate(String message) {
        if (message == null) {
            throw new IllegalArgumentException("null message");
        }
        try {
            return this.authenticate(message.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("\"UTF-8\" is not supported?");
        }
    }

    public String authenticateToString(byte[] message) {
        return Hex.encodeToString(this.authenticate(message));
    }

    public String authenticateToString(String message) {
        return Hex.encodeToString(this.authenticate(message));
    }

    private static class SynchronizedHac
    extends Hac {
        private final Hac hac;

        public SynchronizedHac(Hac hac) {
            if (hac == null) {
                throw new IllegalArgumentException("null hac");
            }
            this.hac = hac;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] authenticate(byte[] message) {
            Hac hac = this.hac;
            synchronized (hac) {
                return this.hac.authenticate(message);
            }
        }
    }
}

