/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.nica.util;

import com.googlecode.jinahya.nica.util.Hac;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

public class HacBC
extends Hac {
    private final HMac mac;

    public static Hac newSynchronizedInstance(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (key.length != 32) {
            throw new IllegalArgumentException("key.length(" + key.length + ") != " + 32);
        }
        final HMac mac = new HMac((Digest)new SHA512Digest());
        mac.init((CipherParameters)new KeyParameter(key));
        return new Hac(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] authenticate(byte[] message) {
                if (message == null) {
                    throw new IllegalArgumentException("null message");
                }
                HMac hMac = mac;
                synchronized (hMac) {
                    byte[] authenticated = new byte[mac.getMacSize()];
                    mac.reset();
                    mac.update(message, 0, message.length);
                    mac.doFinal(authenticated, 0);
                    return authenticated;
                }
            }
        };
    }

    public HacBC(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (key.length != 32) {
            throw new IllegalArgumentException("key.length(" + key.length + ") != " + 32);
        }
        this.mac = new HMac((Digest)new SHA512Digest());
        this.mac.init((CipherParameters)new KeyParameter(key));
    }

    @Override
    public byte[] authenticate(byte[] message) {
        if (message == null) {
            throw new IllegalArgumentException("null message");
        }
        byte[] output = new byte[this.mac.getMacSize()];
        this.mac.reset();
        this.mac.update(message, 0, message.length);
        this.mac.doFinal(output, 0);
        return output;
    }
}

