/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.nica.util;

import com.googlecode.jinahya.nica.util.Hac;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HacJCE
extends Hac {
    private static final String ALGORITHM = "HmacSHA512";
    private final Mac mac;

    public static Hac newSynchronizedInstance(byte[] key) {
        Mac mac;
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (key.length != 32) {
            throw new IllegalArgumentException("key.length(" + key.length + ") != " + 32);
        }
        try {
            mac = Mac.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("\"HmacSHA512\" is not supported?", nsae);
        }
        try {
            mac.init(new SecretKeySpec(key, ALGORITHM));
        }
        catch (InvalidKeyException ike) {
            throw new RuntimeException(ike);
        }
        return new Hac(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] authenticate(byte[] message) {
                if (message == null) {
                    throw new IllegalArgumentException("null message");
                }
                Mac mac2 = mac;
                synchronized (mac2) {
                    mac.reset();
                    mac.update(message);
                    return mac.doFinal();
                }
            }
        };
    }

    public HacJCE(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (key.length != 32) {
            throw new IllegalArgumentException("key.length(" + key.length + ") != " + 32);
        }
        try {
            this.mac = Mac.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("\"HmacSHA512\" is not supported?", nsae);
        }
        try {
            this.mac.init(new SecretKeySpec(key, ALGORITHM));
        }
        catch (InvalidKeyException ike) {
            throw new RuntimeException(ike);
        }
    }

    @Override
    public byte[] authenticate(byte[] message) {
        if (message == null) {
            throw new IllegalArgumentException("null message");
        }
        this.mac.reset();
        this.mac.update(message);
        return this.mac.doFinal();
    }
}

