/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.nica.util;

import com.googlecode.jinahya.nica.util.Hex;
import java.io.UnsupportedEncodingException;

public abstract class Sha {
    public static Sha synchronizedSha(Sha sha) {
        return new SynchronizedSha(sha);
    }

    public abstract byte[] hash(byte[] var1);

    public byte[] hash(String data) {
        if (data == null) {
            throw new IllegalArgumentException("null data");
        }
        try {
            return this.hash(data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException("\"UTF-8\" not supported?");
        }
    }

    public String hashToString(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("null data");
        }
        return Hex.encodeToString(this.hash(data));
    }

    public String hashToString(String data) {
        if (data == null) {
            throw new IllegalArgumentException("null data");
        }
        return Hex.encodeToString(this.hash(data));
    }

    private static class SynchronizedSha
    extends Sha {
        private final Sha sha;

        public SynchronizedSha(Sha sha) {
            if (sha == null) {
                throw new IllegalArgumentException("null sha");
            }
            this.sha = sha;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] hash(byte[] data) {
            Sha sha = this.sha;
            synchronized (sha) {
                return this.sha.hash(data);
            }
        }
    }
}

