/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.nica.util;

import com.googlecode.jinahya.nica.util.Sha;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ShaJCA
extends Sha {
    public static final String ALGORITHM = "SHA-512";
    private final MessageDigest messageDigest;

    public static Sha newSynchronizedInstance() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("\"SHA-512\" not available?");
        }
        return new Sha(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] hash(byte[] data) {
                if (data == null) {
                    throw new IllegalArgumentException("null data");
                }
                MessageDigest messageDigest2 = messageDigest;
                synchronized (messageDigest2) {
                    messageDigest.reset();
                    messageDigest.update(data);
                    return messageDigest.digest();
                }
            }
        };
    }

    public ShaJCA() {
        try {
            this.messageDigest = MessageDigest.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("\"SHA-512\" not available?", nsae);
        }
    }

    @Override
    public byte[] hash(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("null data");
        }
        this.messageDigest.reset();
        this.messageDigest.update(data);
        return this.messageDigest.digest();
    }
}

