/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.nica;

public enum Platform {
    ANDROID("/platforms/android"),
    BLACKBERRY("/platforms/blackberry"),
    IOS("/platforms/ios"),
    JAVA_TV("/platforms/java_tv"),
    TIZEN("/platforms/tizen"),
    UNKNOWN("/platforms/unknown"),
    WINDOWS_PHONE("/platforms/windows_phone");

    private final String id;

    public static Platform fromId(String id) {
        for (Platform value : Platform.values()) {
            if (!value.id.equals(id)) continue;
            return value;
        }
        throw new IllegalArgumentException("unknown id: " + id);
    }

    private Platform(String id) {
        if (id == null) {
            throw new IllegalArgumentException("null id");
        }
        if (id.trim().isEmpty()) {
            throw new IllegalArgumentException("empty id");
        }
        this.id = id;
    }

    public String id() {
        return this.id;
    }
}

