/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.nica.util;

import com.googlecode.jinahya.nica.util.Aes;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesJCE
extends Aes {
    public static final String ALGORITHM = "AES";
    public static final String MODE = "CBC";
    public static final String PADDING = "PKCS5Padding";
    public static final String TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private final Key key;
    private final Cipher cipher;

    public AesJCE(byte[] key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (key.length != 16) {
            throw new IllegalArgumentException("key.length(" + key.length + ") != " + 16);
        }
        this.key = new SecretKeySpec(key, ALGORITHM);
        try {
            this.cipher = Cipher.getInstance(TRANSFORMATION);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("\"AES\" not supported?", nsae);
        }
        catch (NoSuchPaddingException nspe) {
            throw new RuntimeException("\"PKCS5Padding\" not supported?", nspe);
        }
    }

    @Override
    public byte[] encrypt(byte[] iv, byte[] decrypted) {
        if (iv == null) {
            throw new NullPointerException("iv");
        }
        if (iv.length != 16) {
            throw new IllegalArgumentException("iv.length(" + iv.length + ") != " + 16);
        }
        if (decrypted == null) {
            throw new NullPointerException("decrypted");
        }
        try {
            this.cipher.init(1, this.key, new IvParameterSpec(iv));
        }
        catch (InvalidKeyException ike) {
            throw new RuntimeException(ike);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new RuntimeException(iape);
        }
        try {
            return this.cipher.doFinal(decrypted);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new RuntimeException(ibse);
        }
        catch (BadPaddingException bpe) {
            throw new RuntimeException(bpe);
        }
    }

    @Override
    public byte[] decrypt(byte[] iv, byte[] encrypted) {
        if (iv == null) {
            throw new NullPointerException("iv");
        }
        if (iv.length != 16) {
            throw new IllegalArgumentException("iv.length(" + iv.length + ") != " + 16);
        }
        if (encrypted == null) {
            throw new NullPointerException("encrypted");
        }
        try {
            this.cipher.init(2, this.key, new IvParameterSpec(iv));
        }
        catch (InvalidKeyException ike) {
            throw new RuntimeException(ike);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new RuntimeException(iape);
        }
        try {
            return this.cipher.doFinal(encrypted);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new RuntimeException(ibse);
        }
        catch (BadPaddingException bpe) {
            throw new RuntimeException(bpe);
        }
    }
}

