/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.nica.util;

import com.googlecode.jinahya.nica.util.Per;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class Par {
    protected static final String WORD = "[^=&]*";
    protected static final String PAIR = "[^=&]*=[^=&]*";
    protected static final String REGEX = "([^=&]*=[^=&]*)?(&([^=&]*=[^=&]*))*";
    protected static final Pattern PATTERN = Pattern.compile("([^=&]*=[^=&]*)?(&([^=&]*=[^=&]*))*");

    private static <C extends Collection<String>> C split(String j, String d, C s) {
        if (j == null) {
            throw new IllegalArgumentException("null joined");
        }
        if (d == null) {
            throw new IllegalArgumentException("null delimiter");
        }
        if (d.length() == 0) {
            throw new IllegalArgumentException("delimiter.length(" + d.length() + ") == 0");
        }
        if (s == null) {
            throw new IllegalArgumentException("null split");
        }
        int f = 0;
        int i = -1;
        while ((i = j.indexOf(d, f)) != -1) {
            s.add((String)j.substring(f, i));
            f = i + d.length();
        }
        s.add((String)j.substring(f));
        return s;
    }

    private static List<String> split(String j, String d) {
        return Par.split(j, d, new ArrayList());
    }

    protected static String encodeValues(List<String> values, StringBuilder builder) {
        if (values == null) {
            throw new IllegalArgumentException("null values");
        }
        if (values.isEmpty()) {
            throw new IllegalArgumentException("empty values");
        }
        if (builder == null) {
            throw new IllegalArgumentException("null builder");
        }
        ArrayList<String> encoded = new ArrayList<String>(values.size());
        for (String value : values) {
            if (value == null) {
                throw new IllegalArgumentException("null value");
            }
            encoded.add(Per.encodeToString(value));
        }
        Collections.sort(encoded);
        Iterator i = encoded.iterator();
        if (i.hasNext()) {
            builder.append((String)i.next());
        }
        while (i.hasNext()) {
            builder.append('&').append((String)i.next());
        }
        return builder.toString();
    }

    public static String encodeValues(List<String> values) {
        return Par.encodeValues(values, new StringBuilder());
    }

    public static String encodeMultivalued(Map<String, List<String>> decoded, StringBuilder builder) {
        Map.Entry<String, List<String>> entry2;
        if (decoded == null) {
            throw new IllegalArgumentException("null decoded");
        }
        if (builder == null) {
            throw new IllegalArgumentException("null builder");
        }
        TreeMap<String, String> encoded = new TreeMap<String, String>();
        for (Map.Entry<String, List<String>> entry2 : decoded.entrySet()) {
            String key = entry2.getKey();
            if (key == null) {
                throw new IllegalArgumentException("null key detected");
            }
            List<String> values = entry2.getValue();
            if (values == null) {
                throw new IllegalArgumentException("null values detected");
            }
            builder.delete(0, builder.length());
            encoded.put(Per.encodeToString(key), Per.encodeToString(Par.encodeValues(values, builder)));
        }
        builder.delete(0, builder.length());
        Iterator entries = encoded.entrySet().iterator();
        if (entries.hasNext()) {
            entry2 = entries.next();
            builder.append(entry2.getKey()).append('=').append((String)((Object)entry2.getValue()));
        }
        while (entries.hasNext()) {
            entry2 = entries.next();
            builder.append('&').append(entry2.getKey()).append('=').append((String)((Object)entry2.getValue()));
        }
        return builder.toString();
    }

    public static String encodeMultivalued(Map<String, List<String>> decoded) {
        return Par.encodeMultivalued(decoded, new StringBuilder());
    }

    protected static String encode(Map<String, String> decoded, StringBuilder builder) {
        Map.Entry<String, String> entry2;
        if (decoded == null) {
            throw new IllegalArgumentException("null decoded");
        }
        if (decoded.isEmpty()) {
            throw new IllegalArgumentException("empty decoded");
        }
        if (builder == null) {
            throw new IllegalArgumentException("null builder");
        }
        TreeMap<String, String> encoded = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry2 : decoded.entrySet()) {
            String key = entry2.getKey();
            if (key == null) {
                throw new IllegalArgumentException("null key detected");
            }
            String value = entry2.getValue();
            if (value == null) {
                throw new IllegalArgumentException("null value detected");
            }
            encoded.put(Per.encodeToString(key), Per.encodeToString(value));
        }
        Iterator entries = encoded.entrySet().iterator();
        if (entries.hasNext()) {
            entry2 = entries.next();
            builder.append(entry2.getKey()).append('=').append(entry2.getValue());
        }
        while (entries.hasNext()) {
            entry2 = entries.next();
            builder.append('&').append(entry2.getKey()).append('=').append(entry2.getValue());
        }
        return builder.toString();
    }

    public static String encode(Map<String, String> decoded) {
        return Par.encode(decoded, new StringBuilder());
    }

    public static String encode_(Map decoded) {
        Map.Entry entry;
        if (decoded == null) {
            throw new NullPointerException("decoded");
        }
        if (decoded.isEmpty()) {
            return "";
        }
        TreeMap<String, String> encoded = new TreeMap<String, String>();
        for (Map.Entry entry2 : decoded.entrySet()) {
            String key = (String)entry2.getKey();
            if (key == null) {
                throw new IllegalArgumentException("null key");
            }
            String value = (String)entry2.getValue();
            if (value == null) {
                throw new IllegalArgumentException("null value");
            }
            encoded.put(Per.encodeToString(key), Per.encodeToString(value));
        }
        String result = "";
        Iterator entries = encoded.entrySet().iterator();
        if (entries.hasNext()) {
            entry = entries.next();
            result = result + entry.getKey();
            result = result + "=";
            result = result + entry.getValue();
        }
        while (entries.hasNext()) {
            entry = entries.next();
            result = result + "&";
            result = result + entry.getKey();
            result = result + "=";
            result = result + entry.getValue();
        }
        return result;
    }

    protected static List<String> decodeValues(String encoded, List<String> values) {
        for (String split : Par.split(encoded, "&", new ArrayList())) {
            values.add(Per.decodeToString(split));
        }
        return values;
    }

    public static List<String> decodeValues(String encoded) {
        return Par.decodeValues(encoded, new ArrayList<String>());
    }

    public static Map<String, List<String>> decodeMutivalued(String encoded, Map<String, List<String>> decoded) {
        if (encoded == null) {
            throw new IllegalArgumentException("null encoded");
        }
        if (decoded == null) {
            throw new IllegalArgumentException("null decoded");
        }
        if (encoded.isEmpty()) {
            return decoded;
        }
        for (String pair : Par.split(encoded, "&")) {
            String value;
            int index = pair.indexOf(61);
            if (index == -1) {
                throw new IllegalArgumentException("illegal encoded");
            }
            String key = Per.decodeToString(pair.substring(0, index));
            if (decoded.put(key, Par.decodeValues(value = Per.decodeToString(pair.substring(index + 1)))) == null) continue;
            throw new IllegalArgumentException("illegal encoded: duplicate entry for key: " + key);
        }
        return decoded;
    }

    public static Map<String, List<String>> decodeMultiValued(String encoded) {
        return Par.decodeMutivalued(encoded, new HashMap<String, List<String>>());
    }

    protected static Map<String, String> decode(String encoded, Map<String, String> decoded) {
        if (encoded == null) {
            throw new IllegalArgumentException("null encoded");
        }
        if (decoded == null) {
            throw new IllegalArgumentException("null decoded");
        }
        for (String pair : Par.split(encoded, "&")) {
            String value;
            int index = pair.indexOf(61);
            if (index == -1) {
                throw new IllegalArgumentException("illegal encoded");
            }
            String key = Per.decodeToString(pair.substring(0, index));
            if (decoded.put(key, value = Per.decodeToString(pair.substring(index + 1))) == null) continue;
            throw new IllegalArgumentException("illegal encoded: duplicate entry: " + key);
        }
        return decoded;
    }

    public static Map<String, String> decode(String encoded) {
        return Par.decode(encoded, new HashMap<String, String>());
    }

    public static Map decode_(String encoded) {
        if (encoded == null) {
            throw new NullPointerException("encoded");
        }
        if (encoded.length() == 0 || encoded.trim().length() == 0) {
            return new HashMap();
        }
        HashMap<String, String> decoded = new HashMap<String, String>();
        int fromIndex = 0;
        while (fromIndex < encoded.length()) {
            String pair;
            int ampeIndex = encoded.indexOf(38, fromIndex);
            if (ampeIndex == -1) {
                pair = encoded.substring(fromIndex);
                fromIndex = encoded.length();
            } else {
                pair = encoded.substring(fromIndex, ampeIndex);
                fromIndex = ampeIndex + 1;
            }
            int equaIndex = pair.indexOf(61);
            if (equaIndex == -1) {
                throw new IllegalArgumentException("no equal('=') in pair: " + pair);
            }
            decoded.put(Per.decodeToString(pair.substring(0, equaIndex)), Per.decodeToString(pair.substring(equaIndex + 1)));
        }
        return decoded;
    }

    protected Par() {
    }
}

